/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.miscellaneous;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sheath.veinminer.init.ConfigInit;
import com.sheath.veinminer.utils.ModLogger;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class UpdateChecker {
    private static final String API_URL = "https://api.modrinth.com/v2/project/sgtveinminer/version";
    private static final String MODRINTH_VERSION_URL = "https://modrinth.com/mod/sgtveinminer/versions/";
    private static final String CURSEFORGE_FILES_URL = "https://www.curseforge.com/minecraft/mc-mods/veinminer-hc/files";
    private static String latestVersion;
    private static String latestVersionId;
    private static String mcVersion;
    private static volatile boolean checked;

    public static void checkForUpdates() {
        HttpClient client = HttpClient.newHttpClient();
        mcVersion = class_155.method_16673().method_48019();
        String requestUrl = "https://api.modrinth.com/v2/project/sgtveinminer/version?loaders=fabric&game_versions=" + mcVersion;
        HttpRequest request = HttpRequest.newBuilder(URI.create(requestUrl)).header("Accept", "application/json").build();
        ((CompletableFuture)((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenAccept(UpdateChecker::parseResponse)).exceptionally(ex -> {
            ModLogger.warn("Failed to check for updates: {}", ex.getMessage());
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseResponse(String body) {
        try {
            JsonArray array = JsonParser.parseString((String)body).getAsJsonArray();
            if (!array.isEmpty()) {
                JsonObject newest = null;
                for (int i = 0; i < array.size(); ++i) {
                    String newestPublished;
                    JsonObject obj = array.get(i).getAsJsonObject();
                    String versionNumber = obj.get("version_number").getAsString();
                    if (!versionNumber.contains(mcVersion)) continue;
                    if (newest == null) {
                        newest = obj;
                        continue;
                    }
                    String published = obj.get("date_published").getAsString();
                    if (published.compareTo(newestPublished = newest.get("date_published").getAsString()) <= 0) continue;
                    newest = obj;
                }
                if (newest != null) {
                    latestVersion = newest.get("version_number").getAsString();
                    latestVersionId = newest.get("id").getAsString();
                    ModLogger.info("Latest Veinminer version detected: {}", latestVersion);
                } else {
                    ModLogger.warn("No compatible version found for Minecraft {}", mcVersion);
                }
            } else {
                ModLogger.warn("No version information returned from Modrinth", new Object[0]);
            }
        }
        catch (Exception e) {
            ModLogger.warn("Could not parse update information: {}", e.getMessage());
        }
        finally {
            checked = true;
        }
    }

    private static String getCurrentVersion() {
        return FabricLoader.getInstance().getModContainer("veinminermod").map(c -> c.getMetadata().getVersion().getFriendlyString()).orElse("unknown");
    }

    public static boolean isUpdateAvailable() {
        if (!checked || latestVersion == null) {
            return false;
        }
        return !UpdateChecker.getCurrentVersion().equalsIgnoreCase(latestVersion);
    }

    public static void notifyPlayerIfUpdateAvailable(class_3222 player) {
        if (!ConfigInit.GENERAL.updateCheckerEnabled || !checked) {
            return;
        }
        if (!player.method_5687(2)) {
            return;
        }
        String current = UpdateChecker.getCurrentVersion();
        if (latestVersion != null && !current.equalsIgnoreCase(latestVersion)) {
            String modrinthLink = MODRINTH_VERSION_URL + latestVersionId;
            class_5250 msg = class_2561.method_43470((String)"Updates available for Veinminer!\n").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)("Your version " + current + ", please update to the latest version " + latestVersion + "\n")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"CurseForge").method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11749, CURSEFORGE_FILES_URL)))).method_10852((class_2561)class_2561.method_43470((String)"\n").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"Modrinth").method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11749, modrinthLink))));
            player.method_7353((class_2561)msg, false);
        } else {
            String msg = "You are running the latest version of Veinminer " + current + ". No updates available!";
            player.method_7353((class_2561)class_2561.method_43470((String)msg).method_27692(class_124.field_1060), false);
        }
    }
}

