/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.config;

import com.sheath.libs.nightconfig.core.file.CommentedFileConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;

public class AllowedBlocksConfig {
    private static final File FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "Veinminer/AllowedBlocks.toml");
    public Set<String> allowedBlocks = new HashSet<String>();

    public void load(Set<String> defaultBlocks) {
        File parentDir = FILE.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            System.err.println("\u26a0 Failed to create config directory: " + parentDir.getAbsolutePath());
        }
        try (CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(FILE).autosave().sync().preserveInsertionOrder().build();){
            config.load();
            List blocksList = config.getOrElse("blocks", new ArrayList<String>(defaultBlocks));
            this.allowedBlocks = new HashSet<String>(blocksList);
            config.set("blocks", new ArrayList<String>(this.allowedBlocks));
            config.setComment("blocks", "Allowed block registry ids or tag strings starting with '#'");
            config.save();
        }
    }

    public void save() {
        try (CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(FILE).autosave().sync().preserveInsertionOrder().build();){
            config.load();
            config.set("blocks", new ArrayList<String>(this.allowedBlocks));
            config.setComment("blocks", "Allowed block registry ids or tag strings starting with '#'");
            config.save();
        }
    }
}

