/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.sheath.veinminer.config.ConfigService;
import com.sheath.veinminer.config.GeneralConfig;
import com.sheath.veinminer.core.Bootstrap;
import com.sheath.veinminer.util.Translations;
import java.util.NavigableSet;
import java.util.function.Predicate;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

final class BlockPerToolCommand {
    private BlockPerToolCommand() {
    }

    static ArgumentBuilder<class_2168, ?> build(Bootstrap bootstrap, Predicate<class_2168> managePermission) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"blockpertool").requires(managePermission::test)).then(class_2170.method_9247((String)"help").executes(ctx -> BlockPerToolCommand.showHelp((class_2168)ctx.getSource())))).then(BlockPerToolCommand.buildBlocksNode(bootstrap, managePermission))).then(BlockPerToolCommand.buildToolNode(bootstrap, managePermission));
    }

    private static ArgumentBuilder<class_2168, ?> buildBlocksNode(Bootstrap bootstrap, Predicate<class_2168> managePermission) {
        return class_2170.method_9247((String)"blocks").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"tool", (ArgumentType)StringArgumentType.greedyString()).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(managePermission::test)).then(class_2170.method_9244((String)"block", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> BlockPerToolCommand.addBlock((class_2168)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"tool"), StringArgumentType.getString((CommandContext)ctx, (String)"block")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(managePermission::test)).then(class_2170.method_9244((String)"block", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> BlockPerToolCommand.removeBlock((class_2168)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"tool"), StringArgumentType.getString((CommandContext)ctx, (String)"block")))))).then(class_2170.method_9247((String)"list").executes(ctx -> BlockPerToolCommand.listBlocks((class_2168)ctx.getSource(), bootstrap, StringArgumentType.getString((CommandContext)ctx, (String)"tool")))));
    }

    private static ArgumentBuilder<class_2168, ?> buildToolNode(Bootstrap bootstrap, Predicate<class_2168> managePermission) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tool").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(managePermission::test)).then(class_2170.method_9244((String)"tool", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> BlockPerToolCommand.addTool((class_2168)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"tool")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(managePermission::test)).then(class_2170.method_9244((String)"tool", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> BlockPerToolCommand.removeTool((class_2168)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"tool")))))).then(class_2170.method_9247((String)"list").executes(ctx -> BlockPerToolCommand.listTools((class_2168)ctx.getSource(), bootstrap)));
    }

    private static int addBlock(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, String tool, String block) {
        if (!BlockPerToolCommand.ensurePermission(source, managePermission)) {
            return 0;
        }
        if (!BlockPerToolCommand.ensurePerToolMode(source, bootstrap)) {
            return 0;
        }
        GeneralConfig.BlockListMode mode = bootstrap.configService().general().blockListMode();
        class_2561 listDescriptor = BlockPerToolCommand.describePerToolList(mode);
        ConfigService.ChangeResult result = bootstrap.configService().addBlocksPerToolBlock(tool, block);
        switch (result) {
            case SUCCESS: {
                bootstrap.controller().reloadFromConfig();
                source.method_9226(() -> Translations.translate("command.veinminer.blockpertool.block_added", block, listDescriptor, tool), true);
                return 1;
            }
            case ALREADY_PRESENT: {
                source.method_9213(Translations.translate("command.veinminer.blockpertool.block_exists", block, listDescriptor));
                return 0;
            }
            case INVALID: {
                source.method_9213(Translations.translate("command.veinminer.blockpertool.block_not_found", block, listDescriptor, tool));
                return 0;
            }
        }
        source.method_9213(Translations.translate("command.veinminer.blockpertool.block_not_found", block, listDescriptor, tool));
        return 0;
    }

    private static int removeBlock(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, String tool, String block) {
        if (!BlockPerToolCommand.ensurePermission(source, managePermission)) {
            return 0;
        }
        if (!BlockPerToolCommand.ensurePerToolMode(source, bootstrap)) {
            return 0;
        }
        GeneralConfig.BlockListMode mode = bootstrap.configService().general().blockListMode();
        class_2561 listDescriptor = BlockPerToolCommand.describePerToolList(mode);
        ConfigService.ChangeResult result = bootstrap.configService().removeBlocksPerToolBlock(tool, block);
        switch (result) {
            case SUCCESS: {
                bootstrap.controller().reloadFromConfig();
                source.method_9226(() -> Translations.translate("command.veinminer.blockpertool.block_removed", block, listDescriptor, tool), true);
                return 1;
            }
            case NOT_FOUND: {
                source.method_9213(Translations.translate("command.veinminer.blockpertool.block_not_found", block, listDescriptor, tool));
                return 0;
            }
            case INVALID: {
                source.method_9213(Translations.translate("command.veinminer.blockpertool.block_not_found", block, listDescriptor, tool));
                return 0;
            }
        }
        source.method_9213(Translations.translate("command.veinminer.blockpertool.block_not_found", block, listDescriptor, tool));
        return 0;
    }

    private static int listBlocks(class_2168 source, Bootstrap bootstrap, String tool) {
        if (!BlockPerToolCommand.ensurePerToolMode(source, bootstrap)) {
            return 0;
        }
        GeneralConfig.BlockListMode mode = bootstrap.configService().general().blockListMode();
        class_2561 listDescriptor = BlockPerToolCommand.describePerToolList(mode);
        NavigableSet<String> blocks = bootstrap.configService().getBlocksForTool(tool);
        if (blocks == null || blocks.isEmpty()) {
            source.method_9226(() -> Translations.translate("command.veinminer.blockpertool.no_blocks", listDescriptor, tool), false);
        } else {
            source.method_9226(() -> Translations.translate("command.veinminer.blockpertool.blocks_for_tool", listDescriptor, tool), false);
            blocks.forEach(block -> source.method_9226(() -> Translations.translate("command.veinminer.list_entry", block), false));
        }
        return 1;
    }

    private static int addTool(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, String tool) {
        if (!BlockPerToolCommand.ensurePermission(source, managePermission)) {
            return 0;
        }
        if (!BlockPerToolCommand.ensurePerToolMode(source, bootstrap)) {
            return 0;
        }
        ConfigService.ChangeResult result = bootstrap.configService().addBlocksPerToolTool(tool);
        switch (result) {
            case SUCCESS: {
                bootstrap.controller().reloadFromConfig();
                source.method_9226(() -> Translations.translate("command.veinminer.blockpertool.tool_added", tool), true);
                return 1;
            }
            case ALREADY_PRESENT: {
                source.method_9213(Translations.translate("command.veinminer.blockpertool.tool_exists", tool));
                return 0;
            }
            case INVALID: {
                source.method_9213(Translations.translate("command.veinminer.blockpertool.tool_not_found", tool));
                return 0;
            }
        }
        source.method_9213(Translations.translate("command.veinminer.blockpertool.tool_not_found", tool));
        return 0;
    }

    private static int removeTool(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, String tool) {
        if (!BlockPerToolCommand.ensurePermission(source, managePermission)) {
            return 0;
        }
        if (!BlockPerToolCommand.ensurePerToolMode(source, bootstrap)) {
            return 0;
        }
        ConfigService.ChangeResult result = bootstrap.configService().removeBlocksPerToolTool(tool);
        switch (result) {
            case SUCCESS: {
                bootstrap.controller().reloadFromConfig();
                source.method_9226(() -> Translations.translate("command.veinminer.blockpertool.tool_removed", tool), true);
                return 1;
            }
            case INVALID: 
            case NOT_FOUND: {
                source.method_9213(Translations.translate("command.veinminer.blockpertool.tool_not_found", tool));
                return 0;
            }
        }
        source.method_9213(Translations.translate("command.veinminer.blockpertool.tool_not_found", tool));
        return 0;
    }

    private static int listTools(class_2168 source, Bootstrap bootstrap) {
        if (!BlockPerToolCommand.ensurePerToolMode(source, bootstrap)) {
            return 0;
        }
        NavigableSet<String> tools = bootstrap.configService().getAllToolKeys();
        if (tools == null || tools.isEmpty()) {
            source.method_9226(() -> Translations.translate("command.veinminer.blockpertool.no_tools", new Object[0]), false);
        } else {
            source.method_9226(() -> Translations.translate("command.veinminer.blockpertool.tools_header", new Object[0]), false);
            tools.forEach(tool -> source.method_9226(() -> Translations.translate("command.veinminer.list_entry", tool), false));
        }
        return 1;
    }

    private static boolean ensurePerToolMode(class_2168 source, Bootstrap bootstrap) {
        if (bootstrap.configService().general().blockListMode().perTool()) {
            return true;
        }
        source.method_9213(Translations.translate("command.veinminer.blockpertool.not_enabled", new Object[0]));
        return false;
    }

    private static class_2561 describePerToolList(GeneralConfig.BlockListMode mode) {
        String key = mode.blacklist() ? "command.veinminer.block_list_type.per_tool_blacklist" : "command.veinminer.block_list_type.per_tool_whitelist";
        return Translations.translate(key, new Object[0]);
    }

    private static boolean ensurePermission(class_2168 source, Predicate<class_2168> managePermission) {
        if (managePermission.test(source)) {
            return true;
        }
        source.method_9213(Translations.translate("message.veinminer.no_permission", new Object[0]));
        return false;
    }

    private static int showHelp(class_2168 source) {
        source.method_9226(() -> Translations.translate("command.veinminer.help.blockpertool", new Object[0]), false);
        return 1;
    }
}

