/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.concurrent;

import com.sheath.veinminer.util.Log;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public final class TaskExecutor {
    private ExecutorService executor;
    private int configuredThreads = 0;

    public synchronized void configure(int threads) {
        int normalized = Math.max(1, threads);
        if (this.executor != null && !this.executor.isShutdown() && this.configuredThreads == normalized) {
            return;
        }
        this.shutdown();
        this.executor = Executors.newFixedThreadPool(normalized, new WorkerFactory());
        this.configuredThreads = normalized;
        Log.info("Initialised worker pool with {} threads", normalized);
    }

    public ExecutorService executor() {
        ExecutorService current = this.executor;
        if (current == null || current.isShutdown()) {
            throw new IllegalStateException("Task executor not configured");
        }
        return current;
    }

    public CompletableFuture<Void> submitAsync(Runnable task) {
        Objects.requireNonNull(task, "task");
        return CompletableFuture.runAsync(task, this.executor());
    }

    public <T> CompletableFuture<T> submitAsync(Supplier<T> supplier) {
        Objects.requireNonNull(supplier, "supplier");
        return CompletableFuture.supplyAsync(supplier, this.executor());
    }

    public synchronized void shutdown() {
        if (this.executor == null) {
            return;
        }
        ExecutorService toShutdown = this.executor;
        this.executor = null;
        this.configuredThreads = 0;
        toShutdown.shutdown();
        try {
            if (!toShutdown.awaitTermination(10L, TimeUnit.SECONDS)) {
                Log.warn("Worker pool did not terminate gracefully; forcing shutdown", new Object[0]);
                toShutdown.shutdownNow();
                if (!toShutdown.awaitTermination(5L, TimeUnit.SECONDS)) {
                    Log.error("Worker pool still running after forced shutdown", new Object[0]);
                }
            }
        }
        catch (InterruptedException ex) {
            toShutdown.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static final class WorkerFactory
    implements ThreadFactory {
        private final AtomicInteger sequence = new AtomicInteger(1);

        private WorkerFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("veinminer-worker-" + this.sequence.getAndIncrement());
            thread.setUncaughtExceptionHandler((t, throwable) -> Log.error("Uncaught exception in " + t.getName(), throwable));
            return thread;
        }
    }
}

