/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.config;

import com.sheath.veinminer.util.Log;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

final class ConfigFileFormatter {
    private ConfigFileFormatter() {
    }

    static void formatArraysOnePerLine(Path path) {
        try {
            List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
            ArrayList<Object> formatted = new ArrayList<Object>(lines.size());
            for (String line : lines) {
                int firstNonSpace = ConfigFileFormatter.firstNonWhitespaceIndex(line);
                String indent = line.substring(0, firstNonSpace);
                String trimmed = line.substring(firstNonSpace);
                int start = trimmed.indexOf(91);
                int end = trimmed.lastIndexOf(93);
                boolean containsEquals = trimmed.contains("=");
                if (containsEquals && start >= 0 && end > start) {
                    formatted.add(indent + trimmed.substring(0, start + 1));
                    String body = trimmed.substring(start + 1, end).trim();
                    if (!body.isEmpty()) {
                        String[] parts = body.split(",");
                        for (int i = 0; i < parts.length; ++i) {
                            String part = parts[i].trim();
                            boolean isLast = i == parts.length - 1;
                            formatted.add(indent + "    " + part + (isLast ? "" : ","));
                        }
                    }
                    formatted.add(indent + "]" + trimmed.substring(end + 1));
                    continue;
                }
                formatted.add(line);
            }
            Files.write(path, formatted, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException ex) {
            Log.error("Failed to format config file " + String.valueOf(path), ex);
        }
    }

    private static int firstNonWhitespaceIndex(String line) {
        int index;
        for (index = 0; index < line.length() && Character.isWhitespace(line.charAt(index)); ++index) {
        }
        return index;
    }
}

