/*
 * Decompiled with CFR 0.152.
 */
package com.example.voidmod;

import com.example.voidmod.commands.VoidCommand;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod(value="voidmod")
public class VoidMod {
    public static final String MODID = "voidmod";
    private static final Map<UUID, FrozenInfo> FROZEN = new ConcurrentHashMap<UUID, FrozenInfo>();
    private static final BlockParticleOption SHADOW_PARTICLE = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50505_.m_49966_());
    private static final Random RANDOM = new Random();

    public VoidMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        VoidCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (UUID id : new ArrayList<UUID>(FROZEN.keySet())) {
            FrozenInfo info = FROZEN.get(id);
            if (info == null) continue;
            ServerPlayer player = event.getServer().m_6846_().m_11259_(id);
            if (player == null) {
                FROZEN.remove(id);
                continue;
            }
            player.m_20334_(0.0, 0.0, 0.0);
            player.f_8906_.m_9774_(info.x, info.y, info.z, info.yaw, info.pitch);
            Level level = player.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            VoidMod.spawnShadow(serverLevel, info.x, info.y, info.z);
        }
    }

    public static void freezePlayer(ServerPlayer player) {
        double groundY = Math.floor(player.m_20186_()) + 0.01;
        FrozenInfo info = new FrozenInfo(player.m_20185_(), groundY, player.m_20189_(), player.m_146908_(), player.m_146909_());
        FROZEN.put(player.m_20148_(), info);
        player.m_20334_(0.0, 0.0, 0.0);
        player.f_8906_.m_9774_(info.x, info.y, info.z, info.yaw, info.pitch);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, Integer.MAX_VALUE, 0, false, false));
    }

    public static void unfreezePlayer(ServerPlayer player) {
        FROZEN.remove(player.m_20148_());
        player.m_21195_(MobEffects.f_19609_);
    }

    private static void spawnShadow(ServerLevel level, double px, double py, double pz) {
        double dz;
        double dx;
        for (dx = -0.35; dx <= 0.35; dx += 0.07) {
            for (dz = -0.225; dz <= 0.225; dz += 0.07) {
                level.m_8767_((ParticleOptions)SHADOW_PARTICLE, px + dx, py, pz + dz, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        for (dx = -0.22; dx <= 0.22; dx += 0.11) {
            for (dz = -0.34; dz <= 0.34; dz += 0.17) {
                double dist = Math.sqrt(dx * dx + dz * dz);
                if (!(dist < 0.36)) continue;
                level.m_8767_((ParticleOptions)SHADOW_PARTICLE, px + dx, py, pz + dz, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        for (int i = 0; i < 8; ++i) {
            double dx2 = RANDOM.nextDouble() * 0.9 - 0.45;
            double dz2 = RANDOM.nextDouble() * 0.6 - 0.3;
            double vy = py + RANDOM.nextDouble() * 0.02;
            level.m_8767_((ParticleOptions)SHADOW_PARTICLE, px + dx2, vy, pz + dz2, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static final class FrozenInfo {
        final double x;
        final double y;
        final double z;
        final float yaw;
        final float pitch;

        FrozenInfo(double x, double y, double z, float yaw, float pitch) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
        }
    }
}

