/*
 * Decompiled with CFR 0.152.
 */
package mom.wii.takeitslow;

import com.mojang.blaze3d.platform.InputConstants;
import mom.wii.takeitslow.TakeItSlow;
import mom.wii.takeitslow.platform.NeoForgeConfig;
import mom.wii.takeitslow.platform.Services;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@Mod(value="takeitslow", dist={Dist.CLIENT})
public class TakeItSlowNeoForge {
    private static final Lazy<KeyMapping> TOGGLE_KEY_MAPPING = Lazy.of(() -> new KeyMapping("key.takeitslow.toggle", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, -1, KeyMapping.Category.MOVEMENT));

    public TakeItSlowNeoForge(IEventBus eventBus) {
        TakeItSlow.init();
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (client, parent) -> NeoForgeConfig.getScreenFromParent(parent));
        NeoForgeConfig.HANDLER.load();
        eventBus.addListener(TakeItSlowNeoForge::onRegisterKeyMappings);
        NeoForge.EVENT_BUS.addListener(TakeItSlowNeoForge::onPlayerTick);
    }

    private static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)TOGGLE_KEY_MAPPING.get());
    }

    private static void onPlayerTick(PlayerTickEvent.Post event) {
        if (!event.getEntity().isLocalPlayer()) {
            return;
        }
        LocalPlayer player = (LocalPlayer)event.getEntity();
        if (player.isSwimming()) {
            Vec3 delta = player.getDeltaMovement();
            double swimSpeedScale = Services.CONFIG.getSwimSpeedScale();
            Vec3 newDelta = delta.multiply(swimSpeedScale, swimSpeedScale, swimSpeedScale);
            player.setDeltaMovement(newDelta);
        }
        while (((KeyMapping)TOGGLE_KEY_MAPPING.get()).consumeClick()) {
            Services.CONFIG.setEnabled(!Services.CONFIG.getEnabled());
            if (Services.CONFIG.getEnabled()) {
                player.displayClientMessage((Component)Component.translatable((String)"gui.takeitslow.enabled"), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"gui.takeitslow.disabled"), true);
            }
            NeoForgeConfig.HANDLER.save();
        }
    }
}

