/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.togglescoreboard;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import us.mikebartosh.minecraft.togglescoreboard.ToggleScoreboard;

public class Config {
    private static final File FILE = new File("config/toggle_scoreboard.json");
    private static final Gson GSON = new Gson();
    private static boolean toggled = false;

    public static boolean isToggled() {
        return toggled;
    }

    public static void toggleToggled() {
        toggled = !toggled;
        Config.save();
    }

    public static void load() {
        if (!FILE.exists()) {
            Config.save();
            return;
        }
        try (FileReader reader = new FileReader(FILE);){
            JsonObject obj = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (obj != null && obj.has("toggled")) {
                toggled = obj.get("toggled").getAsBoolean();
            }
        }
        catch (IOException e) {
            ToggleScoreboard.LOGGER.error("Had an issue loading the config: {}", (Object)String.valueOf(e));
        }
    }

    static void save() {
        JsonObject obj = new JsonObject();
        obj.addProperty("toggled", Boolean.valueOf(toggled));
        try (FileWriter writer = new FileWriter(FILE);){
            GSON.toJson((JsonElement)obj, (Appendable)writer);
        }
        catch (IOException e) {
            ToggleScoreboard.LOGGER.error("Had an issue saving the config: {}", (Object)String.valueOf(e));
        }
    }
}

