/*
 * Decompiled with CFR 0.152.
 */
package com.creeperconset;

import com.creeperconset.ConsentRequestPayload;
import com.creeperconset.ConsentResponsePayload;
import com.creeperconset.CreeperConsentModClient;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1548;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreeperConsentMod
implements ModInitializer,
ClientModInitializer {
    public static final String MOD_ID = "creeperconset";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"creeperconset");
    public static final class_2960 CONSENT_REQUEST_ID = class_2960.method_60655((String)"creeperconset", (String)"consent_request");
    public static final class_2960 CONSENT_RESPONSE_ID = class_2960.method_60655((String)"creeperconset", (String)"consent_response");
    private static final Map<UUID, class_1548> awaitingConsent = new ConcurrentHashMap<UUID, class_1548>();
    private static final Set<UUID> requestedCreepers = ConcurrentHashMap.newKeySet();
    private static final Set<UUID> clientHandledCreepers = ConcurrentHashMap.newKeySet();
    private static UUID clientPendingCreeperUuid = null;

    public void onInitialize() {
        LOGGER.info("Creeper Consent Mod initialized (Server)");
        PayloadTypeRegistry.playC2S().register(ConsentResponsePayload.ID, ConsentResponsePayload.CODEC);
        PayloadTypeRegistry.playS2C().register(ConsentRequestPayload.ID, ConsentRequestPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ConsentResponsePayload.ID, (payload, context) -> context.server().execute(() -> CreeperConsentMod.handleConsentResponse(payload.creeperUuid(), payload.allowed(), context.player())));
    }

    public void onInitializeClient() {
        LOGGER.info("Creeper Consent Mod initialized (Client)");
        CreeperConsentModClient.registerClientNetworking();
    }

    public static void requestConsent(class_1548 creeper, class_3222 player) {
        UUID creeperUuid = creeper.method_5667();
        if (!requestedCreepers.add(creeperUuid)) {
            return;
        }
        awaitingConsent.put(creeperUuid, creeper);
        ConsentRequestPayload payload = new ConsentRequestPayload(creeperUuid);
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        LOGGER.info("Sent consent request to player {} for creeper {}", (Object)player.method_5477().getString(), (Object)creeperUuid);
    }

    private static void handleConsentResponse(UUID creeperUuid, boolean allowed, class_3222 player) {
        class_1548 creeper = awaitingConsent.remove(creeperUuid);
        requestedCreepers.remove(creeperUuid);
        if (creeper == null || creeper.method_31481()) {
            LOGGER.warn("Creeper {} no longer exists", (Object)creeperUuid);
            return;
        }
        if (allowed) {
            LOGGER.info("Player {} granted consent for explosion", (Object)player.method_5477().getString());
            creeper.method_73183().method_8437((class_1297)creeper, creeper.method_23317(), creeper.method_23318(), creeper.method_23321(), 3.0f, class_1937.class_7867.field_40890);
        } else {
            LOGGER.info("Player {} denied consent", (Object)player.method_5477().getString());
        }
        creeper.method_31472();
    }

    public static boolean setClientPendingCreeper(UUID creeperUuid) {
        if (!clientHandledCreepers.add(creeperUuid)) {
            LOGGER.info("Client already handling creeper {}, ignoring duplicate request", (Object)creeperUuid);
            return false;
        }
        clientPendingCreeperUuid = creeperUuid;
        LOGGER.info("Client received consent request for creeper {}", (Object)creeperUuid);
        return true;
    }

    public static UUID getClientPendingCreeperUuid() {
        return clientPendingCreeperUuid;
    }

    public static void clearClientPendingCreeper(UUID creeperUuid) {
        if (clientPendingCreeperUuid != null && clientPendingCreeperUuid.equals(creeperUuid)) {
            clientPendingCreeperUuid = null;
        }
        clientHandledCreepers.remove(creeperUuid);
    }
}

