/*
 * Decompiled with CFR 0.152.
 */
package de.vexo5566.simpletpa;

import de.vexo5566.simpletpa.commands.ReloadCommand;
import de.vexo5566.simpletpa.commands.TpAcceptCommand;
import de.vexo5566.simpletpa.commands.TpCommand;
import de.vexo5566.simpletpa.commands.TpDenyCommand;
import de.vexo5566.simpletpa.commands.TpHereCommand;
import de.vexo5566.simpletpa.commands.TpToggleCommand;
import de.vexo5566.simpletpa.commands.TpaAllCommand;
import de.vexo5566.simpletpa.commands.TpaCommand;
import de.vexo5566.simpletpa.listener.JoinListener;
import de.vexo5566.simpletpa.manager.LanguageManager;
import de.vexo5566.simpletpa.manager.TPAManager;
import de.vexo5566.simpletpa.utils.UpdateChecker;
import org.bukkit.Sound;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SimpleTPA
extends JavaPlugin {
    private static SimpleTPA instance;
    private TPAManager tpaManager;
    private UpdateChecker updateChecker;
    private LanguageManager languageManager;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.languageManager = new LanguageManager(this);
        this.tpaManager = new TPAManager();
        this.getCommand("tpa").setExecutor((CommandExecutor)new TpaCommand(this));
        this.getCommand("tpahere").setExecutor((CommandExecutor)new TpHereCommand(this));
        this.getCommand("tpaccept").setExecutor((CommandExecutor)new TpAcceptCommand(this));
        this.getCommand("tpadeny").setExecutor((CommandExecutor)new TpDenyCommand(this));
        this.getCommand("tpatoggle").setExecutor((CommandExecutor)new TpToggleCommand(this));
        this.getCommand("tp").setExecutor((CommandExecutor)new TpCommand(this));
        this.getCommand("tpareload").setExecutor((CommandExecutor)new ReloadCommand(this));
        this.getCommand("tpaall").setExecutor((CommandExecutor)new TpaAllCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)new JoinListener(this), (Plugin)this);
        this.updateChecker = new UpdateChecker(this);
        this.updateChecker.checkForUpdates();
        this.sendStartupMessage();
    }

    public void onDisable() {
        this.sendShutdownMessage();
    }

    public static SimpleTPA getInstance() {
        return instance;
    }

    public TPAManager getTpaManager() {
        return this.tpaManager;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public String msg(String key) {
        return this.languageManager.getMessage("prefix") + this.languageManager.getMessage(key);
    }

    public String msg(String key, String ... replacements) {
        return this.languageManager.getMessage("prefix") + this.languageManager.getMessage(key, replacements);
    }

    public void playTpaSound(Player player) {
        if (!this.getConfig().getBoolean("sound.enabled")) {
            return;
        }
        String soundName = this.getConfig().getString("sound.type", "ENTITY_EXPERIENCE_ORB_PICKUP").toUpperCase();
        float volume = (float)this.getConfig().getDouble("sound.volume", 1.0);
        float pitch = (float)this.getConfig().getDouble("sound.pitch", 1.0);
        Sound sound = null;
        for (Sound s : Sound.values()) {
            if (!s.name().equalsIgnoreCase(soundName)) continue;
            sound = s;
            break;
        }
        if (sound == null) {
            this.getLogger().warning("\u26a0\ufe0f Sound '" + soundName + "' not found! Using fallback: ENTITY_EXPERIENCE_ORB_PICKUP");
            sound = Sound.ENTITY_EXPERIENCE_ORB_PICKUP;
        }
        player.playSound(player.getLocation(), sound, volume, pitch);
    }

    private void sendStartupMessage() {
        this.getServer().getConsoleSender().sendMessage("\u00a7b====================================");
        this.getServer().getConsoleSender().sendMessage("\u00a77           \u00a7bPLUGIN STARTED");
        this.getServer().getConsoleSender().sendMessage("\u00a77           \u00a7fPlugin: \u00a7aSimpleTPA");
        this.getServer().getConsoleSender().sendMessage("\u00a77           \u00a7fVersion: \u00a7a" + this.getDescription().getVersion());
        this.getServer().getConsoleSender().sendMessage("\u00a77           \u00a7fAuthor: \u00a7a" + String.join((CharSequence)", ", this.getDescription().getAuthors()));
        this.getServer().getConsoleSender().sendMessage("\u00a7b====================================");
    }

    private void sendShutdownMessage() {
        this.getServer().getConsoleSender().sendMessage("\u00a7c====================================");
        this.getServer().getConsoleSender().sendMessage("\u00a77           \u00a7cPLUGIN STOPPED");
        this.getServer().getConsoleSender().sendMessage("\u00a77           \u00a7fPlugin: \u00a7aSimpleTPA");
        this.getServer().getConsoleSender().sendMessage("\u00a77           \u00a7fVersion: \u00a7a" + this.getDescription().getVersion());
        this.getServer().getConsoleSender().sendMessage("\u00a77           \u00a7fAuthor: \u00a7a" + String.join((CharSequence)", ", this.getDescription().getAuthors()));
        this.getServer().getConsoleSender().sendMessage("\u00a7c====================================");
    }
}

