/*
 * Decompiled with CFR 0.152.
 */
package de.vexo5566.simpletpa.commands;

import de.vexo5566.simpletpa.SimpleTPA;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class ReloadCommand
implements CommandExecutor {
    private final SimpleTPA plugin;

    public ReloadCommand(SimpleTPA plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("simpletpa.reload")) {
            sender.sendMessage(this.plugin.msg("no_permission"));
            return true;
        }
        sender.sendMessage("\u00a7e[SimpleTPA] " + this.plugin.getLanguageManager().getMessage("reload_start"));
        try {
            this.plugin.reloadConfig();
            this.plugin.getLanguageManager().reload();
            if (this.plugin.getUpdateChecker() != null) {
                this.plugin.getUpdateChecker().checkForUpdates();
            }
            sender.sendMessage("\u00a7a[SimpleTPA] " + this.plugin.getLanguageManager().getMessage("reload_success"));
            sender.sendMessage("\u00a7a[SimpleTPA] " + this.plugin.getLanguageManager().getMessage("reload_language").replace("%language%", this.plugin.getLanguageManager().getCurrentLanguage()));
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7c[SimpleTPA] " + this.plugin.getLanguageManager().getMessage("reload_error").replace("%error%", e.getMessage()));
            this.plugin.getLogger().severe("Error during reload: " + e.getMessage());
            e.printStackTrace();
        }
        return true;
    }
}

