/*
 * Decompiled with CFR 0.152.
 */
package de.vexo5566.simpletpa.commands;

import de.vexo5566.simpletpa.SimpleTPA;
import de.vexo5566.simpletpa.manager.TPAManager;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TpHereCommand
implements CommandExecutor {
    private final SimpleTPA plugin;

    public TpHereCommand(SimpleTPA plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("only_players"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            player.sendMessage(this.plugin.getLanguageManager().getMessage("usage_tpahere"));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null || !target.isOnline()) {
            player.sendMessage(this.plugin.msg("player_not_found"));
            return true;
        }
        if (player.equals((Object)target)) {
            player.sendMessage(this.plugin.msg("cannot_send_to_self"));
            return true;
        }
        if (this.plugin.getTpaManager().isToggledOff(target)) {
            player.sendMessage(this.plugin.msg("tpa_disabled_target"));
            return true;
        }
        TPAManager.TpaRequest request = new TPAManager.TpaRequest(player, target, true);
        this.plugin.getTpaManager().addRequest(request);
        player.sendMessage(this.plugin.msg("tpa_here_sent", "%target%", target.getName()));
        target.sendMessage(this.plugin.msg("tpa_here_received", "%sender%", player.getName()));
        String acceptText = this.plugin.getLanguageManager().getMessage("button_accept");
        String denyText = this.plugin.getLanguageManager().getMessage("button_deny");
        String acceptHover = this.plugin.getLanguageManager().getMessage("button_accept_hover");
        String denyHover = this.plugin.getLanguageManager().getMessage("button_deny_hover");
        TextComponent accept = new TextComponent(acceptText);
        accept.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(acceptHover).create()));
        accept.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpaccept"));
        TextComponent deny = new TextComponent(" " + denyText);
        deny.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(denyHover).create()));
        deny.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpadeny"));
        target.spigot().sendMessage(new BaseComponent[]{accept, deny});
        this.plugin.playTpaSound(target);
        return true;
    }
}

