/*
 * Decompiled with CFR 0.152.
 */
package de.vexo5566.simpletpa.commands;

import de.vexo5566.simpletpa.SimpleTPA;
import de.vexo5566.simpletpa.manager.TPAManager;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TpaAllCommand
implements CommandExecutor {
    private final SimpleTPA plugin;

    public TpaAllCommand(SimpleTPA plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("only_players"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("simpletpa.tpaall")) {
            player.sendMessage(this.plugin.msg("no_permission"));
            return true;
        }
        int sentCount = 0;
        int skippedCount = 0;
        for (Player target : Bukkit.getOnlinePlayers()) {
            if (target.equals((Object)player)) continue;
            if (this.plugin.getTpaManager().isToggledOff(target)) {
                ++skippedCount;
                continue;
            }
            TPAManager.TpaRequest request = new TPAManager.TpaRequest(player, target, true);
            this.plugin.getTpaManager().addRequest(request);
            target.sendMessage(this.plugin.msg("tpa_here_received", "%sender%", player.getName()));
            String acceptText = this.plugin.getLanguageManager().getMessage("button_accept");
            String denyText = this.plugin.getLanguageManager().getMessage("button_deny");
            String acceptHover = this.plugin.getLanguageManager().getMessage("button_accept_hover");
            String denyHover = this.plugin.getLanguageManager().getMessage("button_deny_hover");
            TextComponent accept = new TextComponent(acceptText);
            accept.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(acceptHover).create()));
            accept.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpaccept"));
            TextComponent deny = new TextComponent(" " + denyText);
            deny.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(denyHover).create()));
            deny.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpadeny"));
            target.spigot().sendMessage(new BaseComponent[]{accept, deny});
            this.plugin.playTpaSound(target);
            ++sentCount;
        }
        if (sentCount == 0 && skippedCount == 0) {
            player.sendMessage(this.plugin.msg("tpaall_no_players"));
        } else {
            player.sendMessage(this.plugin.msg("tpaall_sent", "%sent%", String.valueOf(sentCount), "%skipped%", String.valueOf(skippedCount)));
        }
        return true;
    }
}

