/*
 * Decompiled with CFR 0.152.
 */
package de.vexo5566.simpletpa.libs.gson.internal.bind;

import de.vexo5566.simpletpa.libs.gson.Gson;
import de.vexo5566.simpletpa.libs.gson.JsonSyntaxException;
import de.vexo5566.simpletpa.libs.gson.ToNumberPolicy;
import de.vexo5566.simpletpa.libs.gson.ToNumberStrategy;
import de.vexo5566.simpletpa.libs.gson.TypeAdapter;
import de.vexo5566.simpletpa.libs.gson.TypeAdapterFactory;
import de.vexo5566.simpletpa.libs.gson.reflect.TypeToken;
import de.vexo5566.simpletpa.libs.gson.stream.JsonReader;
import de.vexo5566.simpletpa.libs.gson.stream.JsonToken;
import de.vexo5566.simpletpa.libs.gson.stream.JsonWriter;
import java.io.IOException;

public final class NumberTypeAdapter
extends TypeAdapter<Number> {
    private static final TypeAdapterFactory LAZILY_PARSED_NUMBER_FACTORY = NumberTypeAdapter.newFactory(ToNumberPolicy.LAZILY_PARSED_NUMBER);
    private final ToNumberStrategy toNumberStrategy;

    private NumberTypeAdapter(ToNumberStrategy toNumberStrategy) {
        this.toNumberStrategy = toNumberStrategy;
    }

    private static TypeAdapterFactory newFactory(ToNumberStrategy toNumberStrategy) {
        NumberTypeAdapter adapter = new NumberTypeAdapter(toNumberStrategy);
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                return type.getRawType() == Number.class ? NumberTypeAdapter.this : null;
            }
        };
    }

    public static TypeAdapterFactory getFactory(ToNumberStrategy toNumberStrategy) {
        if (toNumberStrategy == ToNumberPolicy.LAZILY_PARSED_NUMBER) {
            return LAZILY_PARSED_NUMBER_FACTORY;
        }
        return NumberTypeAdapter.newFactory(toNumberStrategy);
    }

    @Override
    public Number read(JsonReader in) throws IOException {
        JsonToken jsonToken = in.peek();
        switch (jsonToken) {
            case NULL: {
                in.nextNull();
                return null;
            }
            case NUMBER: 
            case STRING: {
                return this.toNumberStrategy.readNumber(in);
            }
        }
        throw new JsonSyntaxException("Expecting number, got: " + (Object)((Object)jsonToken) + "; at path " + in.getPath());
    }

    @Override
    public void write(JsonWriter out, Number value) throws IOException {
        out.value(value);
    }
}

