/*
 * Decompiled with CFR 0.152.
 */
package de.vexo5566.simpletpa.manager;

import de.vexo5566.simpletpa.SimpleTPA;
import de.vexo5566.simpletpa.libs.gson.Gson;
import de.vexo5566.simpletpa.libs.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class LanguageManager {
    private final SimpleTPA plugin;
    private JsonObject messages;
    private String currentLanguage;

    public LanguageManager(SimpleTPA plugin) {
        this.plugin = plugin;
        this.currentLanguage = plugin.getConfig().getString("language", "en");
        this.loadLanguage();
    }

    private void loadLanguage() {
        block9: {
            File langFile;
            File langFolder = new File(this.plugin.getDataFolder(), "languages");
            if (!langFolder.exists()) {
                langFolder.mkdirs();
            }
            if (!(langFile = new File(langFolder, this.currentLanguage + ".json")).exists()) {
                this.plugin.saveResource("languages/" + this.currentLanguage + ".json", false);
            }
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(langFile), StandardCharsets.UTF_8);){
                Gson gson = new Gson();
                this.messages = gson.fromJson((Reader)reader, JsonObject.class);
                this.plugin.getLogger().info("\u00a7aLanguage loaded: " + this.currentLanguage);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("\u00a7cCould not load language file: " + this.currentLanguage + ".json");
                e.printStackTrace();
                if (this.currentLanguage.equals("en")) break block9;
                this.plugin.getLogger().info("\u00a7eFalling back to English...");
                this.currentLanguage = "en";
                this.loadLanguage();
            }
        }
    }

    public String getMessage(String key) {
        try {
            String message = this.messages.get(key).getAsString();
            return message.replace("&", "\u00a7");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u00a7cMissing translation key: " + key);
            return "\u00a7c[Missing: " + key + "]";
        }
    }

    public String getMessage(String key, String ... replacements) {
        String message = this.getMessage(key);
        for (int i = 0; i < replacements.length; i += 2) {
            if (i + 1 >= replacements.length) continue;
            message = message.replace(replacements[i], replacements[i + 1]);
        }
        return message;
    }

    public void reload() {
        this.currentLanguage = this.plugin.getConfig().getString("language", "en");
        this.loadLanguage();
    }

    public String getCurrentLanguage() {
        return this.currentLanguage;
    }
}

