/*
 * Decompiled with CFR 0.152.
 */
package de.vexo5566.simpletpa.manager;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;

public class TPAManager {
    private final HashMap<UUID, TpaRequest> requests = new HashMap();
    private final Set<UUID> toggledOff = new HashSet<UUID>();

    public void addRequest(TpaRequest request) {
        this.requests.put(request.getTarget().getUniqueId(), request);
    }

    public void removeRequest(Player target) {
        this.requests.remove(target.getUniqueId());
    }

    public boolean hasRequest(Player target) {
        return this.requests.containsKey(target.getUniqueId());
    }

    public Player getRequester(Player target) {
        TpaRequest req = this.requests.get(target.getUniqueId());
        return req != null ? req.getSender() : null;
    }

    public TpaRequest getRequest(Player target) {
        return this.requests.get(target.getUniqueId());
    }

    public void toggle(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.toggledOff.contains(uuid)) {
            this.toggledOff.remove(uuid);
        } else {
            this.toggledOff.add(uuid);
        }
    }

    public boolean isToggledOff(Player player) {
        return this.toggledOff.contains(player.getUniqueId());
    }

    public static class TpaRequest {
        private final Player sender;
        private final Player target;
        private final boolean here;

        public TpaRequest(Player sender, Player target, boolean here) {
            this.sender = sender;
            this.target = target;
            this.here = here;
        }

        public Player getSender() {
            return this.sender;
        }

        public Player getTarget() {
            return this.target;
        }

        public boolean isHere() {
            return this.here;
        }
    }
}

