/*
 * Decompiled with CFR 0.152.
 */
package de.vexo5566.simpletpa.utils;

import de.vexo5566.simpletpa.SimpleTPA;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private static final String GITHUB_USER = "Tamino112";
    private static final String REPO_NAME = "simpletpa";
    private static final String DOWNLOAD_URL = "https://modrinth.com/plugin/simple-tpa-vexo/changelog";
    private final SimpleTPA plugin;
    private final String currentVersion;
    private String latestVersion;
    private boolean updateAvailable = false;

    public UpdateChecker(SimpleTPA plugin) {
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
    }

    public void checkForUpdates() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                String apiUrl = "https://api.github.com/repos/Tamino112/simpletpa/releases/latest";
                HttpURLConnection connection = (HttpURLConnection)new URL(apiUrl).openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Accept", "application/vnd.github.v3+json");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                if (connection.getResponseCode() == 200) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    reader.close();
                    String json = response.toString();
                    this.latestVersion = this.parseVersion(json);
                    if (this.latestVersion != null && !this.currentVersion.equals(this.latestVersion)) {
                        this.updateAvailable = true;
                        this.plugin.getLogger().info("\u00a7a======================================");
                        this.plugin.getLogger().info("\u00a7e\u26a0 A new update is available!");
                        this.plugin.getLogger().info("\u00a77Current Version: \u00a7c" + this.currentVersion);
                        this.plugin.getLogger().info("\u00a77Latest Version: \u00a7a" + this.latestVersion);
                        this.plugin.getLogger().info("\u00a77Download: \u00a7bhttps://modrinth.com/plugin/simple-tpa-vexo/changelog");
                        this.plugin.getLogger().info("\u00a7a======================================");
                    } else {
                        this.plugin.getLogger().info("\u00a7aYou are using the latest version!");
                    }
                } else {
                    this.plugin.getLogger().warning("\u00a7cKonnte nicht nach Updates suchen (HTTP " + connection.getResponseCode() + ")");
                }
                connection.disconnect();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("\u00a7cFehler beim Update-Check: " + e.getMessage());
            }
        });
    }

    private String parseVersion(String json) {
        try {
            int versionEnd;
            int tagStart = json.indexOf("\"tag_name\"");
            if (tagStart == -1) {
                return null;
            }
            int versionStart = json.indexOf("\"", tagStart + 11) + 1;
            String version = json.substring(versionStart, versionEnd = json.indexOf("\"", versionStart));
            return version.startsWith("v") ? version.substring(1) : version;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public String getDownloadUrl() {
        return DOWNLOAD_URL;
    }
}

