/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.economical_villager_trading.config;

import java.util.function.Function;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.minecraft.class_437;
import net.sssubtlety.economical_villager_trading.EconomicalVillagerTrading;
import net.sssubtlety.economical_villager_trading.config.Config;
import net.sssubtlety.economical_villager_trading.config.DefaultConfig;

@me.shedaniel.autoconfig.annotation.Config(name="economical_villager_trading")
public class ClothConfig
implements ConfigData,
Config {
    @ConfigEntry.Gui.Tooltip
    double villagerTradeAdjustBalance = DefaultConfig.INSTANCE.villagerTradeAdjustBalance();
    @ConfigEntry.Gui.Tooltip
    boolean enableReputationPriceAdjustments = DefaultConfig.INSTANCE.enableReputationPriceAdjustments();
    @ConfigEntry.Gui.Tooltip
    double villagerXpMultiplier = DefaultConfig.INSTANCE.villagerXpMultiplier();
    @ConfigEntry.Gui.Tooltip
    boolean enableVillagerLevelupWhileTrading = DefaultConfig.INSTANCE.enableVillagerLevelupWhileTrading();
    @ConfigEntry.Gui.Tooltip
    boolean doVanillaRestocks = DefaultConfig.INSTANCE.doVanillaRestocks();

    static ClothConfig register() {
        return (ClothConfig)AutoConfig.register(ClothConfig.class, GsonConfigSerializer::new).getConfig();
    }

    public void validatePostLoad() {
        if (this.villagerTradeAdjustBalance < -1.0) {
            this.villagerTradeAdjustBalance = -1.0;
        } else if (this.villagerTradeAdjustBalance > 100.0) {
            this.villagerTradeAdjustBalance = 100.0;
        }
        if (this.villagerXpMultiplier < 0.0) {
            EconomicalVillagerTrading.LOGGER.warn("XP multiplier can't be less than 0.");
            this.villagerXpMultiplier = 0.0;
        }
        if (this.villagerXpMultiplier > 2.0) {
            EconomicalVillagerTrading.LOGGER.warn("XP multiplier can't be grater than 2.");
            this.villagerXpMultiplier = 2.0;
        }
    }

    @Override
    public double villagerTradeAdjustBalance() {
        return this.villagerTradeAdjustBalance;
    }

    @Override
    public boolean enableReputationPriceAdjustments() {
        return this.enableReputationPriceAdjustments;
    }

    @Override
    public double villagerXpMultiplier() {
        return this.villagerXpMultiplier;
    }

    @Override
    public boolean enableVillagerLevelupWhileTrading() {
        return this.enableVillagerLevelupWhileTrading;
    }

    @Override
    public boolean doVanillaRestocks() {
        return this.doVanillaRestocks;
    }

    @Override
    public Function<class_437, ? extends class_437> screenFactory() {
        return parent -> (class_437)AutoConfig.getConfigScreen(ClothConfig.class, (class_437)parent).get();
    }
}

