/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.economical_villager_trading.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import net.fabricmc.fabric.api.tag.convention.v2.TagUtil;
import net.minecraft.class_1646;
import net.minecraft.class_1728;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_3850;
import net.minecraft.class_3851;
import net.minecraft.class_4094;
import net.minecraft.class_4140;
import net.sssubtlety.economical_villager_trading.EconomicalVillagerTrading;
import net.sssubtlety.economical_villager_trading.config.ConfigManager;
import net.sssubtlety.economical_villager_trading.mixin.MerchantEntityMixin;
import net.sssubtlety.economical_villager_trading.mixin.accessor.TradeOfferAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1646.class})
abstract class VillagerEntityMixin
extends MerchantEntityMixin
implements class_4094,
class_3851 {
    @Unique
    private ThreadLocal<Boolean> restockingBuys;
    @Unique
    private ThreadLocal<Boolean> restockingAll;
    @Unique
    private ThreadLocal<Boolean> trackRestocks;
    @Shadow
    private long field_18537;

    VillagerEntityMixin() {
    }

    @Unique
    private static boolean isBuyTrade(class_1914 tradeOffer) {
        return TagUtil.isIn(EconomicalVillagerTrading.BUY_TRADE_CURRENCIES, (Object)tradeOffer.method_8250().method_7909());
    }

    @Unique
    private static boolean shouldRestock(class_1914 tradeOffer, ThreadLocal<Boolean> restockingAll, ThreadLocal<Boolean> restockingBuys) {
        return VillagerEntityMixin.shouldRestock(tradeOffer, restockingAll.get(), restockingBuys.get());
    }

    @Unique
    private static boolean shouldRestock(class_1914 tradeOffer, boolean all, boolean buys) {
        return all || buys == VillagerEntityMixin.isBuyTrade(tradeOffer);
    }

    @Shadow
    public abstract class_3850 method_7231();

    @Shadow
    public abstract int method_19269();

    @Shadow
    public abstract boolean method_20708();

    @Shadow
    public abstract void method_19182();

    @Shadow
    protected abstract void method_21724();

    @Shadow
    protected abstract void method_49695();

    @Override
    protected void tryRefreshPostTrade(class_1914 offer, CallbackInfo ci) {
        if (offer.method_8255()) {
            this.restockingBuys.set(!VillagerEntityMixin.isBuyTrade(offer));
            this.restock(!VillagerEntityMixin.isBuyTrade(offer));
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/World;Lnet/minecraft/registry/Holder;)V"}, at={@At(value="TAIL")})
    private void initFields(CallbackInfo ci) {
        this.restockingBuys = ThreadLocal.withInitial(() -> false);
        this.restockingAll = ThreadLocal.withInitial(() -> false);
        this.trackRestocks = ThreadLocal.withInitial(() -> true);
    }

    @Inject(method={"tryDailyRestock"}, cancellable=true, at={@At(value="FIELD", opcode=181, shift=At.Shift.AFTER, target="Lnet/minecraft/entity/passive/VillagerEntity;lastRestockCheckTime:J")})
    private void shouldNotRestockUnlessAllTradesDisabled(CallbackInfoReturnable<Boolean> cir) {
        if (ConfigManager.doVanillaRestocks() || this.method_73183().method_8510() > this.field_18537 + 12000L && this.areAllTradesDisabled()) {
            this.restockingAll.set(true);
        } else {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"tryDailyRestock"}, at={@At(shift=At.Shift.AFTER, value="INVOKE", target="Lnet/minecraft/entity/passive/VillagerEntity;doDailyRestock()V")})
    private void removeRefreshingAll(CallbackInfoReturnable<Boolean> cir) {
        this.restockingAll.remove();
    }

    @WrapWithCondition(method={"restock"}, at={@At(value="FIELD", opcode=181, target="Lnet/minecraft/entity/passive/VillagerEntity;lastRestockTime:J")})
    private boolean ifTracking(class_1646 instance, long value) {
        return this.trackRestocks.get();
    }

    @WrapWithCondition(method={"restock"}, at={@At(value="FIELD", opcode=181, target="Lnet/minecraft/entity/passive/VillagerEntity;restocksToday:I")})
    private boolean ifTracking(class_1646 instance, int value) {
        return this.trackRestocks.get();
    }

    @Inject(method={"restock"}, at={@At(value="RETURN")})
    private void updateTradeGui(CallbackInfo ci) {
        this.updateTradeGui();
    }

    @Inject(method={"levelUp"}, at={@At(value="RETURN")})
    private void refreshAllPostLevelUp(CallbackInfo info) {
        this.restockingAll.set(true);
        this.trackRestocks.set(false);
        try {
            this.method_19182();
        }
        finally {
            this.trackRestocks.remove();
        }
        if (ConfigManager.villagerLevelingWithGuiOpenEnabled()) {
            this.updateTradeGui();
        }
    }

    @Inject(method={"updateDemandBonus"}, at={@At(value="HEAD")}, cancellable=true)
    private void balancePriceAdjustments(CallbackInfo ci) {
        block5: {
            double dilutionFactor = ConfigManager.getVillagerTradeAdjustBalance();
            if (!(dilutionFactor >= 0.0)) break block5;
            ci.cancel();
            if (dilutionFactor >= 100.0) {
                for (class_1914 offer : this.method_8264()) {
                    ((TradeOfferAccessor)offer).economical_villager_trading$setDemandBonus(0);
                }
            } else {
                Object2DoubleArrayMap useRatios = new Object2DoubleArrayMap();
                class_1916 offers = this.method_8264();
                boolean allTradesDisabled = this.areAllTradesDisabled();
                double useRatioSum = 0.0;
                for (class_1914 offer : offers) {
                    if (!allTradesDisabled && !VillagerEntityMixin.shouldRestock(offer, this.restockingAll, this.restockingBuys)) continue;
                    double useRatio = (double)offer.method_8249() / (double)offer.method_8248();
                    useRatioSum += useRatio;
                    useRatios.put((Object)offer, useRatio);
                }
                double averageUseRatio = useRatioSum / (double)offers.size();
                for (Object2DoubleMap.Entry entry : useRatios.object2DoubleEntrySet()) {
                    class_1914 offer = (class_1914)entry.getKey();
                    ((TradeOfferAccessor)offer).economical_villager_trading$setDemandBonus(this.getAdjustedBonus(averageUseRatio, offer, entry.getDoubleValue(), dilutionFactor));
                }
            }
        }
    }

    @ModifyArg(method={"afterUsing"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ExperienceOrbEntity;<init>(Lnet/minecraft/world/World;DDDI)V"))
    private int multiplyXp(int originalValue) {
        return (int)(ConfigManager.getVillagerXpMultiplier() * (double)originalValue);
    }

    @ModifyExpressionValue(method={"mobTick"}, allow=1, require=1, slice={@Slice(to=@At(value="INVOKE", target="Lnet/minecraft/entity/passive/VillagerEntity;levelUp()V"))}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/passive/VillagerEntity;hasCustomer()Z")})
    private boolean allowLevelingWithCustomerIfEnabled(boolean hasCustomer) {
        return hasCustomer && !ConfigManager.villagerLevelingWithGuiOpenEnabled();
    }

    @Unique
    private void restock(boolean buys) {
        this.method_21724();
        for (class_1914 offer : this.method_8264()) {
            if (!offer.method_8255() || !this.hasWorkStation() || !this.areAllTradesDisabled() && !VillagerEntityMixin.shouldRestock(offer, false, buys)) continue;
            offer.method_19275();
        }
        this.method_49695();
        this.updateTradeGui();
    }

    @Unique
    private void updateTradeGui() {
        if (this.method_8257() != null && this.method_8257().field_7512 instanceof class_1728) {
            this.method_8257().method_17354(this.method_8257().field_7512.field_7763, this.method_8264(), this.method_7231().comp_3522(), this.method_19269(), this.method_19270(), this.method_20708());
        }
    }

    @Unique
    private int getAdjustedBonus(double avgUseRatio, class_1914 offer, double useRatio, double dilutionFactor) {
        return Math.round(Math.round((double)offer.method_21725() * ((useRatio + dilutionFactor) / (avgUseRatio + dilutionFactor))));
    }

    @Unique
    private boolean areAllTradesDisabled() {
        for (class_1914 offer : this.method_8264()) {
            if (offer.method_8255()) continue;
            return false;
        }
        return true;
    }

    @Unique
    private boolean hasWorkStation() {
        return this.method_18868().method_18904(class_4140.field_18439).isPresent();
    }
}

