/*
 * Decompiled with CFR 0.152.
 */
package net.system737.zombification.convertor;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.slf4j.Logger;

public class Convertor {
    private static Resource conversionRecipe;
    private static final Gson GSON;
    private static final Logger LOGGER;
    private static final List<ConversionPair<?, ?>> conversionPairs;

    public static void getConversionFile(Resource conversionFile) {
        conversionRecipe = conversionFile;
        LOGGER.info("Found conversion file: " + conversionFile.toString());
        Convertor.generateConvertibles();
    }

    private static void generateConversionPair(Map.Entry<String, JsonElement> conversionPair) {
        Convertor.generateConversionPair(conversionPair.getKey(), conversionPair.getValue().getAsString());
    }

    private static void generateConversionPair(String mobName, String zombieName) {
        EntityType mobType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(mobName));
        EntityType zombieType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(zombieName));
        if (mobType != null && zombieType != null) {
            ConversionPair<EntityType, EntityType> pair = new ConversionPair<EntityType, EntityType>(mobType, zombieType);
            conversionPairs.add(pair);
            LOGGER.info("Generated conversion pair: (" + mobName + ", " + zombieName + ").");
        }
    }

    private static void generateConvertibles() {
        try {
            InputStreamReader reader = new InputStreamReader(conversionRecipe.m_215507_());
            JsonReader r = new JsonReader((Reader)reader);
            JsonObject object = (JsonObject)GSON.fromJson(r, JsonObject.class);
            object.entrySet().forEach(Convertor::generateConversionPair);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean conversionPairExists(LivingEntity entity) {
        List<ConversionPair> pairs = conversionPairs.stream().filter(pair -> pair.getMob() == entity.m_6095_()).toList();
        return !pairs.isEmpty();
    }

    public static void convertMobEntity(Mob mob) {
        List<ConversionPair> pairs = conversionPairs.stream().filter(pair -> pair.getMob() == mob.m_6095_()).toList();
        if (!pairs.isEmpty()) {
            ConversionPair pair2 = pairs.get(0);
            Object zombie = pair2.getZombie();
            mob.m_21406_(zombie, true);
        }
    }

    static {
        GSON = new Gson();
        LOGGER = LogUtils.getLogger();
        conversionPairs = new ArrayList();
    }

    public static class ConversionPair<M extends EntityType<?>, Z extends EntityType<?>> {
        private final M Mob;
        private final Z Zombie;

        public ConversionPair(M Mob2, Z Zombie) {
            this.Mob = Mob2;
            this.Zombie = Zombie;
        }

        public M getMob() {
            return this.Mob;
        }

        public Z getZombie() {
            return this.Zombie;
        }
    }
}

