/*
 * Decompiled with CFR 0.152.
 */
package net.system737.zombification.forge;

import com.mojang.logging.LogUtils;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.system737.zombification.ZombificationMod;
import net.system737.zombification.effect.ZombificationEffect;
import net.system737.zombification.forge.brewing.BrewingRecipe;
import org.slf4j.Logger;

@Mod(value="zombification")
public final class ZombificationForge {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"zombification");
    public static final DeferredRegister<Potion> POTIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"zombification");
    public static final RegistryObject<MobEffect> ZOMBIFICATION_EFFECT = EFFECTS.register("zombification", ZombificationEffect::new);
    public static final RegistryObject<Potion> ZOMBIFICATION_POTION = POTIONS.register("zombification", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)ZOMBIFICATION_EFFECT.get())}));

    public ZombificationForge() {
        ZombificationMod.init();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        EFFECTS.register(modEventBus);
        POTIONS.register(modEventBus);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        LOGGER.info("Hello from Zombification Forge!");
        forgeEventBus.addListener(ZombificationForge::serverStarting);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Common setup has started...");
        event.enqueueWork(() -> BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BrewingRecipe(Potions.f_43584_, Items.f_42583_, (Potion)ZOMBIFICATION_POTION.get())));
    }

    private static void loadConversionFile(ResourceManager manager) {
        LOGGER.info("Loading the conversion file...");
        ZombificationMod.loadConversionFile(manager, LOGGER);
    }

    public static void serverStarting(ServerStartingEvent event) {
        LOGGER.info("Server setup has started...");
        ZombificationForge.loadConversionFile(event.getServer().m_177941_());
    }
}

