/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.remapped.color;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.remapped.Remapped;
import dev.worldgen.remapped.duck.MapColorDuck;
import java.util.HexFormat;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;
import net.minecraft.class_9848;

public record RemappedColor(int color, boolean useDithering, class_6885<class_2248> blocks, class_6885<class_1959> biomes, int priority) implements MapColorDuck
{
    public static final class_5321<class_2378<RemappedColor>> REGISTRY_KEY = class_5321.method_29180((class_2960)Remapped.id("color"));
    public static final Codec<Integer> STRING_RGB_COLOR = Codec.withAlternative((Codec)RemappedColor.hexColor().xmap(class_9848::method_61334, class_9848::method_61335), (Codec)class_5699.field_54067);
    public static final Codec<RemappedColor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)STRING_RGB_COLOR.fieldOf("color").forGetter(RemappedColor::color), (App)Codec.BOOL.fieldOf("use_dithering").orElse((Object)false).forGetter(RemappedColor::useDithering), (App)class_6895.method_40340((class_5321)class_7924.field_41254).fieldOf("blocks").forGetter(RemappedColor::blocks), (App)class_1959.field_26750.fieldOf("biomes").orElse((Object)class_6885.method_58563()).forGetter(RemappedColor::biomes), (App)Codec.INT.fieldOf("priority").orElse((Object)1000).forGetter(RemappedColor::priority)).apply((Applicative)instance, RemappedColor::new));

    @Override
    public int getColor() {
        return this.color;
    }

    private static Codec<Integer> hexColor() {
        return Codec.STRING.comapFlatMap(string -> {
            if (!string.startsWith("#")) {
                return DataResult.error(() -> "Hex color must begin with #");
            }
            int hexLength = string.length() - "#".length();
            if (hexLength != 6) {
                return DataResult.error(() -> "Hex color is wrong size, expected 6 digits but got " + hexLength);
            }
            try {
                long value = HexFormat.fromHexDigitsToLong(string, "#".length(), string.length());
                return value >= 0L && value <= 0xFFFFFFL ? DataResult.success((Object)((int)value)) : DataResult.error(() -> "Color value out of range: " + string);
            }
            catch (NumberFormatException e) {
                return DataResult.error(() -> "Invalid color value: " + string);
            }
        }, value -> "#" + HexFormat.of().toHexDigits(value.intValue(), 6));
    }
}

