/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.remapped.mixin.common;

import dev.worldgen.remapped.duck.HoldingPlayerDuck;
import dev.worldgen.remapped.duck.MapDataDuck;
import dev.worldgen.remapped.network.BaseMapUpdatePacket;
import dev.worldgen.remapped.network.RemappedMapUpdatePacket;
import dev.worldgen.remapped.util.RemappedMapPatch;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_8710;
import net.minecraft.class_9209;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_22.class_23.class})
public abstract class HoldingPlayerMixin
implements HoldingPlayerDuck {
    @Shadow
    @Final
    class_22 field_132;
    @Shadow
    private int field_129;
    @Shadow
    private int field_128;
    @Shadow
    private int field_127;
    @Shadow
    private int field_126;
    @Shadow
    private boolean field_130;
    @Shadow
    private boolean field_27891;
    @Shadow
    private int field_124;
    @Unique
    private boolean initialized = false;

    @Shadow
    protected abstract class_22.class_5637 method_32375();

    private RemappedMapPatch createRemappedPatch(MapDataDuck data) {
        if (!this.initialized) {
            this.field_129 = 0;
            this.field_128 = 0;
            this.field_127 = 127;
            this.field_126 = 127;
            this.initialized = true;
        }
        int minX = this.field_129;
        int minY = this.field_128;
        int width = this.field_127 + 1 - this.field_129;
        int height = this.field_126 + 1 - this.field_128;
        ArrayList<Integer> colors = new ArrayList<Integer>();
        for (int i = 0; i < width * height; ++i) {
            colors.add(0);
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                colors.set(x + y * width, data.getRemappedColors().get(minX + x + (minY + y) * 128));
            }
        }
        return new RemappedMapPatch(minX, minY, width, height, colors);
    }

    @Override
    public List<class_8710> remapped$createRemappedPackets(class_9209 id) {
        RemappedMapPatch remappedPatch = null;
        class_22.class_5637 patch = null;
        if (this.field_130 || !this.initialized) {
            remappedPatch = this.createRemappedPatch(MapDataDuck.cast(this.field_132));
            if ((this.field_124 + 3) % 5 == 0) {
                patch = this.method_32375();
            }
        }
        ArrayList<class_20> decorations = new ArrayList<class_20>();
        if (this.field_27891 && this.field_124++ % 5 == 0) {
            this.field_27891 = false;
            decorations.addAll(MapDataDuck.cast(this.field_132).getDecorations().values());
        }
        ArrayList<class_8710> packets = new ArrayList<class_8710>();
        if (remappedPatch != null) {
            packets.add(RemappedMapUpdatePacket.create(id, this.field_132.field_119, this.field_132.field_17403, remappedPatch));
        }
        if (patch != null || !decorations.isEmpty()) {
            packets.add(BaseMapUpdatePacket.create(id, this.field_132.field_119, this.field_132.field_17403, null, decorations));
        }
        return packets;
    }
}

