/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.remapped.mixin.common;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import dev.worldgen.remapped.color.RemappedColor;
import dev.worldgen.remapped.duck.MapColorDuck;
import dev.worldgen.remapped.util.RemappedUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1806;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3532;
import net.minecraft.class_3620;
import net.minecraft.class_4076;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1806.class})
public abstract class MapItemMixin {
    @Shadow
    protected abstract class_2680 method_7995(class_1937 var1, class_2680 var2, class_2338 var3);

    @Inject(method={"method_7998(Lnet/minecraft/class_1937;Lnet/minecraft/class_1297;Lnet/minecraft/class_22;)V"}, at={@At(value="HEAD")})
    private void updateRemappedColors(class_1937 level, class_1297 entity, class_22 data, CallbackInfo ci) {
        if (level.method_27983() == data.field_118 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_2378 registry = level.method_30349().method_30530(RemappedColor.REGISTRY_KEY);
            int scale = 1 << data.field_119;
            int centerX = data.field_116;
            int centerZ = data.field_115;
            int playerImgX = class_3532.method_15357((double)(player.method_23317() - (double)centerX)) / scale + 64;
            int playerImgY = class_3532.method_15357((double)(player.method_23321() - (double)centerZ)) / scale + 64;
            int radius = 128 / scale;
            if (level.method_8597().comp_643()) {
                radius /= 2;
            }
            class_22.class_23 holdingPlayer = data.method_101(player);
            class_2338.class_2339 blockPos = new class_2338.class_2339();
            class_2338.class_2339 belowPos = new class_2338.class_2339();
            boolean foundConsecutiveChanges = false;
            for (int imgX = playerImgX - radius; imgX < playerImgX + radius; ++imgX) {
                if ((imgX & 0xF) != (holdingPlayer.field_131 & 0xF) && !foundConsecutiveChanges) continue;
                foundConsecutiveChanges = false;
                double previousAverageAreaHeight = 0.0;
                for (int imgY = playerImgY - radius - 1; imgY < playerImgY + radius; ++imgY) {
                    double diff;
                    if (imgX < 0 || imgY < -1 || imgX >= 128 || imgY >= 128) continue;
                    int distanceToPlayerSqr = class_3532.method_34954((int)(imgX - playerImgX)) + class_3532.method_34954((int)(imgY - playerImgY));
                    boolean ditherBlack = distanceToPlayerSqr > (radius - 2) * (radius - 2);
                    int averagingAreaMinX = (centerX / scale + imgX - 64) * scale;
                    int averagingAreaMinZ = (centerZ / scale + imgY - 64) * scale;
                    LinkedHashMultiset colorCount = LinkedHashMultiset.create();
                    class_2818 chunk = level.method_8497(class_4076.method_18675((int)averagingAreaMinX), class_4076.method_18675((int)averagingAreaMinZ));
                    if (chunk.method_12223()) continue;
                    int waterDepth = 0;
                    double averageAreaHeight = 0.0;
                    if (level.method_8597().comp_643()) {
                        int ceilingNoise = averagingAreaMinX + averagingAreaMinZ * 231871;
                        if (((ceilingNoise = ceilingNoise * ceilingNoise * 31287121 + ceilingNoise * 11) >> 20 & 1) == 0) {
                            colorCount.add((Object)((MapColorDuck)RemappedUtils.get((class_2378<RemappedColor>)registry, RemappedUtils.DIRT_BROWN).comp_349()), 10);
                        } else {
                            colorCount.add((Object)((MapColorDuck)RemappedUtils.get((class_2378<RemappedColor>)registry, RemappedUtils.STONE_GRAY).comp_349()), 100);
                        }
                        averageAreaHeight = 100.0;
                    } else {
                        for (int averagingAreaDeltaX = 0; averagingAreaDeltaX < scale; ++averagingAreaDeltaX) {
                            for (int averagingAreaDeltaZ = 0; averagingAreaDeltaZ < scale; ++averagingAreaDeltaZ) {
                                class_2680 state;
                                blockPos.method_10103(averagingAreaMinX + averagingAreaDeltaX, 0, averagingAreaMinZ + averagingAreaDeltaZ);
                                int columnY = chunk.method_12005(class_2902.class_2903.field_13202, blockPos.method_10263(), blockPos.method_10260()) + 1;
                                if (columnY <= level.method_31607()) {
                                    state = class_2246.field_9987.method_9564();
                                } else {
                                    do {
                                        blockPos.method_33098(--columnY);
                                    } while (RemappedUtils.getMatchingColor(level, (class_2338)blockPos, state = chunk.method_8320((class_2338)blockPos)).getColor() == 0 && columnY > level.method_31607());
                                    if (columnY > level.method_31607() && !state.method_26227().method_15769()) {
                                        class_2680 belowBlock;
                                        int solidY = columnY - 1;
                                        belowPos.method_10101((class_2382)blockPos);
                                        do {
                                            belowPos.method_33098(solidY--);
                                            belowBlock = chunk.method_8320((class_2338)belowPos);
                                            ++waterDepth;
                                        } while (solidY > level.method_31607() && !belowBlock.method_26227().method_15769());
                                        state = this.method_7995(level, state, (class_2338)blockPos);
                                    }
                                }
                                data.method_109((class_1922)level, blockPos.method_10263(), blockPos.method_10260());
                                averageAreaHeight += (double)columnY / (double)(scale * scale);
                                colorCount.add((Object)RemappedUtils.getMatchingColor(level, (class_2338)blockPos, state));
                            }
                        }
                    }
                    MapColorDuck color = (MapColorDuck)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)colorCount), (Object)MapColorDuck.empty());
                    class_3620.class_6594 brightness = color.useDithering() ? ((diff = (double)(waterDepth /= scale * scale) * 0.1 + (double)(imgX + imgY & 1) * 0.2) < 0.5 ? class_3620.class_6594.field_34761 : (diff > 0.9 ? class_3620.class_6594.field_34759 : class_3620.class_6594.field_34760)) : ((diff = (averageAreaHeight - previousAverageAreaHeight) * 4.0 / (double)(scale + 4) + ((double)(imgX + imgY & 1) - 0.5) * 0.4) > 0.6 ? class_3620.class_6594.field_34761 : (diff < -0.6 ? class_3620.class_6594.field_34759 : class_3620.class_6594.field_34760));
                    previousAverageAreaHeight = averageAreaHeight;
                    if (imgY < 0 || distanceToPlayerSqr >= radius * radius || ditherBlack && (imgX + imgY & 1) == 0) continue;
                    foundConsecutiveChanges |= RemappedUtils.putColor(data, imgX, imgY, color, brightness.field_34763);
                }
            }
        }
    }
}

