/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.remapped.mixin.common;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.remapped.duck.HoldingPlayerDuck;
import dev.worldgen.remapped.duck.MapDataDuck;
import dev.worldgen.remapped.util.CodecExtender;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9209;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_22.class})
public abstract class MapItemSavedDataMixin
implements MapDataDuck {
    @Shadow
    @Final
    private Map<class_1657, class_22.class_23> field_120;
    @Shadow
    @Final
    private Map<String, class_20> field_117;
    @Unique
    private ArrayList<Integer> remappedColors = MapDataDuck.getDefaultColorList();

    @Shadow
    protected abstract void method_103(int var1, int var2);

    @Override
    public ArrayList<Integer> getRemappedColors() {
        this.sanitizeColorSize();
        return this.remappedColors;
    }

    @Override
    public void setRemappedColors(List<Integer> colors) {
        this.remappedColors = new ArrayList<Integer>(colors);
    }

    @Override
    public void setRemappedColor(int x, int y, int color) {
        this.sanitizeColorSize();
        int index = x + y * 128;
        if (this.remappedColors.get(index) != color) {
            this.remappedColors.set(index, color);
            this.method_103(x, y);
        }
    }

    @Unique
    private void sanitizeColorSize() {
        if (this.remappedColors.size() < 16384) {
            this.remappedColors = MapDataDuck.getDefaultColorList();
        }
    }

    @Override
    public List<class_8710> getRemappedPackets(class_9209 mapId, class_3222 player) {
        class_22.class_23 holdingPlayer = this.field_120.get(player);
        return holdingPlayer == null ? List.of() : ((HoldingPlayerDuck)holdingPlayer).remapped$createRemappedPackets(mapId);
    }

    @Override
    public Map<String, class_20> getDecorations() {
        return this.field_117;
    }

    @ModifyReturnValue(method={"method_32361()Lnet/minecraft/class_22;"}, at={@At(value="RETURN")})
    private class_22 copyColors(class_22 data) {
        ((MapDataDuck)data).setRemappedColors(this.getRemappedColors());
        return data;
    }

    @Redirect(method={"<clinit>()V"}, at=@At(value="INVOKE", target="Lcom/mojang/serialization/codecs/RecordCodecBuilder;create(Ljava/util/function/Function;)Lcom/mojang/serialization/Codec;"))
    private static Codec<class_22> wrapCodec(Function<RecordCodecBuilder.Instance<class_22>, ? extends App<RecordCodecBuilder.Mu<class_22>, class_22>> builder) {
        return CodecExtender.extend(RecordCodecBuilder.create(builder), (instance, wrapper) -> instance.group((App)wrapper, (App)Codec.INT.listOf().optionalFieldOf("remapped:colors", MapDataDuck.getDefaultColorList()).forGetter(mapState -> MapDataDuck.cast(mapState).getRemappedColors())).apply((Applicative)instance, (mapState, colors) -> {
            MapDataDuck.cast(mapState).setRemappedColors((List<Integer>)colors);
            return mapState;
        }));
    }
}

