/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.remapped.util;

import dev.worldgen.remapped.Remapped;
import dev.worldgen.remapped.color.ColorMapper;
import dev.worldgen.remapped.color.RemappedColor;
import dev.worldgen.remapped.duck.MapColorDuck;
import dev.worldgen.remapped.duck.MapDataDuck;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_22;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9848;

public class RemappedUtils {
    public static final class_5321<RemappedColor> DIRT_BROWN = RemappedUtils.of("dirt_brown");
    public static final class_5321<RemappedColor> STONE_GRAY = RemappedUtils.of("stone_gray");

    private static class_5321<RemappedColor> of(String name) {
        return class_5321.method_29179(RemappedColor.REGISTRY_KEY, (class_2960)Remapped.id(name));
    }

    public static int getColor(class_22 data, int index, int color) {
        MapDataDuck accessor = MapDataDuck.cast(data);
        int remappedColor = accessor.getRemappedColors().get(index);
        return remappedColor != 0 ? class_9848.method_61337((int)remappedColor) : color;
    }

    private static boolean colorMatched(class_6880<RemappedColor> entry, class_6880<class_1959> biome, class_2680 state) {
        RemappedColor color = (RemappedColor)entry.comp_349();
        if (!state.method_40143(color.blocks())) {
            return false;
        }
        return color.biomes().method_40247() == 0 || color.biomes().method_40241(biome);
    }

    public static MapColorDuck getMatchingColor(class_1937 level, class_2338 pos, class_2680 state) {
        class_6880 biome = level.method_23753(pos);
        for (class_6880<RemappedColor> color : ColorMapper.getColors((class_6880<class_2248>)state.method_41520())) {
            if (!RemappedUtils.colorMatched(color, (class_6880<class_1959>)biome, state)) continue;
            return (MapColorDuck)color.comp_349();
        }
        return (MapColorDuck)state.method_26205((class_1922)level, pos);
    }

    public static int applyBrightness(int color, int brightness) {
        int i = switch (brightness) {
            case 0 -> 180;
            case 1 -> 220;
            case 2 -> 255;
            case 3 -> 135;
            default -> 0;
        };
        int j = (color >> 16 & 0xFF) * i / 255;
        int k = (color >> 8 & 0xFF) * i / 255;
        int l = (color & 0xFF) * i / 255;
        return 0xFF000000 | l << 16 | k << 8 | j;
    }

    public static class_6880<RemappedColor> get(class_2378<RemappedColor> registry, class_5321<RemappedColor> key) {
        return (class_6880)registry.method_46746(key).get();
    }

    public static boolean putColor(class_22 data, int x, int y, MapColorDuck holder, int brightness) {
        int color = RemappedUtils.applyBrightness(holder.getColor(), brightness);
        int index = x + y * 128;
        MapDataDuck accessor = MapDataDuck.cast(data);
        if (accessor.getRemappedColors().get(index) != color) {
            accessor.setRemappedColor(x, y, color);
            return true;
        }
        return false;
    }
}

