/*
 * Decompiled with CFR 0.152.
 */
package com.starlotte.cobblemon_move_inspector.client;

import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.starlotte.cobblemon_move_inspector.client.GraalTypeChartGetter;
import java.util.HashMap;
import java.util.UUID;

public class MoveEffectivenessLookup {
    private static final HashMap<String, HashMap<String, Float>> typeChart = new HashMap();
    private static final GraalTypeChartGetter typeChartGetter = new GraalTypeChartGetter();

    public static float getModifier(MoveTemplate move, ElementalType defenderType1, ElementalType defenderType2, UUID player) {
        ElementalType moveType = move.getElementalType();
        float damageMult = 1.0f;
        if (move != null) {
            if (defenderType1 != null) {
                damageMult *= MoveEffectivenessLookup.getMultFromType(move.getName(), moveType.getName(), defenderType1.getName());
            }
            if (defenderType2 != null) {
                damageMult *= MoveEffectivenessLookup.getMultFromType(move.getName(), moveType.getName(), defenderType2.getName());
            }
        }
        return damageMult;
    }

    public static float getMultFromType(String moveName, String moveType, String defenderType) {
        Float typeDamageType;
        HashMap<String, Float> matchupMap = typeChart.get(defenderType.toLowerCase());
        float multPower = 1.0f;
        if (matchupMap == null) {
            return multPower;
        }
        Float moveDamageType = matchupMap.get(moveName.toLowerCase());
        if (moveDamageType != null && !moveName.equals(moveType)) {
            multPower *= moveDamageType.floatValue();
        }
        if ((typeDamageType = matchupMap.get(moveType.toLowerCase())) != null) {
            multPower *= typeDamageType.floatValue();
        }
        return multPower;
    }

    public static float getMult(int damage) {
        return switch (damage) {
            default -> 1.0f;
            case 1 -> 2.0f;
            case 2 -> 0.5f;
            case 3 -> 0.0f;
        };
    }

    static {
        typeChartGetter.openConnection();
        typeChartGetter.getTypeChart(typeChart);
    }
}

