/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.blocks;

import com.keletu.renaissance_core.blocks.TileQuicksilverCrucible;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.entities.EntitySpecialItem;

public class BlockQuicksilverCrucible
extends BlockContainer {
    protected static final AxisAlignedBB AABB_LEGS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0);
    protected static final AxisAlignedBB AABB_WALL_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB AABB_WALL_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_EAST = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);
    private int delay = 0;

    public BlockQuicksilverCrucible() {
        super(Material.field_151573_f);
        this.func_149711_c(3.0f);
        this.func_149752_b(17.0f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World w, BlockPos pos, Random r) {
        TileEntity te;
        if (r.nextInt(10) == 0 && (te = w.func_175625_s(pos)) instanceof TileQuicksilverCrucible && ((TileQuicksilverCrucible)te).aspects.getAmount(Aspect.EXCHANGE) > 0) {
            w.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new SoundEvent(new ResourceLocation("renaissance_core:melted")), SoundCategory.BLOCKS, 1.1f + r.nextFloat() * 0.1f, 1.2f + r.nextFloat() * 0.2f, false);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K) {
            TileQuicksilverCrucible tile = (TileQuicksilverCrucible)world.func_175625_s(pos);
            if (tile != null && entity instanceof EntityItem && !(entity instanceof EntitySpecialItem)) {
                tile.attemptSmelt((EntityItem)entity);
            } else {
                ++this.delay;
                if (this.delay < 10) {
                    return;
                }
                this.delay = 0;
                if (entity instanceof EntityLivingBase && tile != null) {
                    entity.func_70097_a(DamageSource.field_76372_a, 1.0f);
                    world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.4f, 2.0f + world.field_73012_v.nextFloat() * 0.4f, false);
                }
            }
        }
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        BlockQuicksilverCrucible.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_LEGS);
        BlockQuicksilverCrucible.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_WEST);
        BlockQuicksilverCrucible.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_NORTH);
        BlockQuicksilverCrucible.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_EAST);
        BlockQuicksilverCrucible.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_SOUTH);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileQuicksilverCrucible) {
            float var10000 = ((TileQuicksilverCrucible)te).aspects.visSize();
            ((Object)((Object)((TileQuicksilverCrucible)te))).getClass();
            float r = var10000 / 100.0f;
            return MathHelper.func_76141_d((float)(r * 14.0f)) + (((TileQuicksilverCrucible)te).aspects.visSize() > 0 ? 1 : 0);
        }
        return 0;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos l) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileQuicksilverCrucible) {
            ((TileQuicksilverCrucible)te).getBellows();
        }
        super.func_189540_a(state, world, pos, block, l);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileQuicksilverCrucible();
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return null;
    }
}

