/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.client.render;

import com.keletu.renaissance_core.client.render.ShaderCallback;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.ARBShaderObjects;
import thaumcraft.common.config.ModConfig;

public class ShaderHelper {
    private static final int VERT = 35633;
    private static final int FRAG = 35632;
    private static final String PREFIX = "/assets/renaissance_core/shaders/";
    public static int endShader = 0;
    public static int endScreenShader = 0;
    public static int atsralFrameShader = 0;
    public static int distortionShader = 0;
    public static int hexRunesShader = 0;
    public static int wiggleShader = 0;
    public static int blinkShader = 0;
    public static int etherealShader = 0;
    public static int crimsonShader = 0;

    public static void initShaders() {
        if (!ShaderHelper.useShaders()) {
            return;
        }
        endShader = ShaderHelper.createProgram("ender.vert", "ender.frag");
        endScreenShader = ShaderHelper.createProgram("ender.vert", "ender_screen.frag");
        atsralFrameShader = ShaderHelper.createProgram(null, "atsral_frame.frag");
        distortionShader = ShaderHelper.createProgram(null, "distortion.frag");
        hexRunesShader = ShaderHelper.createProgram(null, "hex_runes.frag");
        wiggleShader = ShaderHelper.createProgram("wiggle.vert", "wiggle.frag");
        blinkShader = ShaderHelper.createProgram(null, "blink.frag");
        etherealShader = ShaderHelper.createProgram(null, "ethereal.frag");
        crimsonShader = ShaderHelper.createProgram(null, "crimson_orb.frag");
    }

    public static void useShader(int shader, ShaderCallback callback) {
        if (!ShaderHelper.useShaders()) {
            return;
        }
        ARBShaderObjects.glUseProgramObjectARB((int)shader);
        if (shader != 0) {
            int time = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"time");
            if (Minecraft.func_71410_x().func_175606_aa() == null) {
                return;
            }
            ARBShaderObjects.glUniform1iARB((int)time, (int)Minecraft.func_71410_x().func_175606_aa().field_70173_aa);
            if (callback != null) {
                callback.call(shader);
            }
        }
    }

    public static void useShader(int shader) {
        ShaderHelper.useShader(shader, null);
    }

    public static void releaseShader() {
        ShaderHelper.useShader(0);
    }

    public static boolean useShaders() {
        return !ModConfig.CONFIG_GRAPHICS.disableShaders && OpenGlHelper.field_148824_g;
    }

    private static int createProgram(String vert, String frag) {
        int vertId = 0;
        int fragId = 0;
        int program = 0;
        if (vert != null) {
            vertId = ShaderHelper.createShader(PREFIX + vert, 35633);
        }
        if (frag != null) {
            fragId = ShaderHelper.createShader(PREFIX + frag, 35632);
        }
        if ((program = ARBShaderObjects.glCreateProgramObjectARB()) == 0) {
            return 0;
        }
        if (vert != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)vertId);
        }
        if (frag != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)fragId);
        }
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            return 0;
        }
        ARBShaderObjects.glValidateProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35715) == 0) {
            return 0;
        }
        return program;
    }

    private static int createShader(String filename, int shaderType) {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)ShaderHelper.readFileAsString(filename));
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + ShaderHelper.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception e) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            e.printStackTrace();
            return -1;
        }
    }

    private static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileAsString(String filename) throws Exception {
        StringBuilder source;
        block26: {
            source = new StringBuilder();
            InputStream in = ShaderHelper.class.getResourceAsStream(filename);
            Exception exception = null;
            if (in == null) {
                return "";
            }
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                Exception innerExc = null;
                try {
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            source.append(line).append('\n');
                        }
                    }
                    catch (Exception var31) {
                        exception = var31;
                    }
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception var30) {
                        if (innerExc == null) {
                            innerExc = var30;
                        }
                        var30.printStackTrace();
                    }
                }
                if (innerExc != null) {
                    throw innerExc;
                }
            }
            catch (Exception var33) {
                exception = var33;
                return exception;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception var29) {
                    if (exception == null) {
                        exception = var29;
                    }
                    var29.printStackTrace();
                }
                if (exception == null) break block26;
                throw exception;
            }
        }
        return source.toString();
    }
}

