/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.entity;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.casters.FocusEffect;

public class EntityPositiveBurstOrb
extends Entity
implements IEntityAdditionalSpawnData {
    public int orbAge = 0;
    public int orbMaxAge = 150;
    public int orbCooldown;
    private int orbHealth = 5;
    public boolean vitaminize;
    public boolean fulfillment;
    private EntityPlayer closestPlayer;

    public boolean func_70112_a(double par1) {
        double d1 = 0.5;
        return par1 < (d1 *= 64.0 * field_70155_l) * d1;
    }

    public EntityPositiveBurstOrb(World world, double x, double y, double z, FocusEffect effect) {
        super(world);
        this.func_70105_a(0.125f, 0.125f);
        this.func_70107_b(x, y, z);
        this.field_70177_z = (float)(Math.random() * 360.0);
        if (effect != null) {
            this.vitaminize = effect.getSettingValue("function") == 1;
            this.fulfillment = effect.getSettingValue("function") == 2;
        }
    }

    public double func_70033_W() {
        return this.field_70131_O / 2.0f;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public EntityPositiveBurstOrb(World par1World) {
        super(par1World);
        this.func_70105_a(0.125f, 0.125f);
    }

    protected void func_70088_a() {
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        float f1 = 0.5f;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        int i = super.func_70070_b();
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f1 * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public void func_70071_h_() {
        double d3;
        double d2;
        double d1;
        double d4;
        double d5;
        List targets;
        super.func_70071_h_();
        if (this.orbCooldown > 0) {
            --this.orbCooldown;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= (double)0.03f;
        if (this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v))).func_185904_a() == Material.field_151587_i) {
            this.field_70181_x = 0.2f;
            this.field_70159_w = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
            this.field_70179_y = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
            this.func_184185_a(SoundEvents.field_187659_cY, 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
        }
        this.func_145771_j(this.field_70165_t, (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.field_70161_v);
        double d0 = 8.0;
        if (this.field_70173_aa % 5 == 0 && this.closestPlayer == null && (targets = this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72314_b(d0, d0, d0))).size() > 0) {
            double distance = Double.MAX_VALUE;
            for (Entity t : targets) {
                double d = t.func_70032_d((Entity)this);
                if (!(d < distance)) continue;
                distance = d;
                this.closestPlayer = (EntityPlayer)t;
            }
        }
        if (this.closestPlayer != null && (d5 = 1.0 - (d4 = Math.sqrt((d1 = (this.closestPlayer.field_70165_t - this.field_70165_t) / d0) * d1 + (d2 = (this.closestPlayer.field_70163_u + (double)this.closestPlayer.func_70047_e() - this.field_70163_u) / d0) * d2 + (d3 = (this.closestPlayer.field_70161_v - this.field_70161_v) / d0) * d3))) > 0.0) {
            d5 *= d5;
            this.field_70159_w += d1 / d4 * d5 * 0.1;
            this.field_70181_x += d2 / d4 * d5 * 0.1;
            this.field_70179_y += d3 / d4 * d5 * 0.1;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        float f = 0.98f;
        if (this.field_70122_E) {
            f = 0.58800006f;
            IBlockState i = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v)));
            if (!i.func_177230_c().isAir(i, (IBlockAccess)this.field_70170_p, new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v)))) {
                f = i.func_177230_c().field_149765_K * 0.98f;
            }
        }
        this.field_70159_w *= (double)f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)f;
        if (this.field_70122_E) {
            this.field_70181_x *= (double)-0.9f;
        }
        ++this.orbAge;
        if (this.orbAge >= this.orbMaxAge) {
            this.func_70106_y();
        }
    }

    public boolean func_70072_I() {
        return this.field_70170_p.func_72918_a(this.func_174813_aQ(), Material.field_151586_h, (Entity)this);
    }

    protected void func_70081_e(int par1) {
        this.func_70097_a(DamageSource.field_76372_a, par1);
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return false;
        }
        if (this.func_180431_b(par1DamageSource)) {
            return false;
        }
        this.func_70018_K();
        this.orbHealth = (int)((float)this.orbHealth - par2);
        if (this.orbHealth <= 0) {
            this.func_70106_y();
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74777_a("Health", (short)((byte)this.orbHealth));
        par1NBTTagCompound.func_74777_a("Age", (short)this.orbAge);
        par1NBTTagCompound.func_74757_a("Fulfillment", this.fulfillment);
        par1NBTTagCompound.func_74757_a("Vitaminize", this.vitaminize);
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        this.orbHealth = par1NBTTagCompound.func_74765_d("Health") & 0xFF;
        this.orbAge = par1NBTTagCompound.func_74765_d("Age");
        this.fulfillment = par1NBTTagCompound.func_74767_n("Fulfillment");
        this.vitaminize = par1NBTTagCompound.func_74767_n("Vitaminize");
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
        if (!this.field_70170_p.field_72995_K && this.orbCooldown == 0 && par1EntityPlayer.field_71090_bL == 0 && !par1EntityPlayer.func_190530_aW()) {
            if (this.fulfillment) {
                if (par1EntityPlayer.func_110139_bj() < 20.0f) {
                    par1EntityPlayer.func_110149_m(par1EntityPlayer.func_110139_bj() + 1.0f);
                }
            } else if (this.vitaminize) {
                switch (this.field_70146_Z.nextInt(3)) {
                    case 0: {
                        par1EntityPlayer.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 200, 1));
                        break;
                    }
                    case 1: {
                        par1EntityPlayer.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 200, 1));
                        break;
                    }
                    case 2: {
                        par1EntityPlayer.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 200, 1));
                    }
                }
            } else {
                par1EntityPlayer.func_70691_i(0.5f);
            }
            par1EntityPlayer.field_71090_bL = 2;
            this.func_184185_a(SoundEvents.field_187604_bf, 0.1f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
            this.func_70106_y();
        }
    }

    public boolean func_70075_an() {
        return false;
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.fulfillment) {
            buffer.writeChar(102);
        } else if (this.vitaminize) {
            buffer.writeChar(118);
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        try {
            char c = additionalData.readChar();
            if (c == 'f') {
                this.fulfillment = true;
            } else if (c == 'v') {
                this.vitaminize = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

