/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.events;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.keletu.renaissance_core.items.ItemDice12;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class KeepDiceEvent {
    private Map<UUID, ItemStack> diceMap = new HashMap<UUID, ItemStack>();
    private Map<UUID, Integer> slotMap = new HashMap<UUID, Integer>();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerDeathHigh(PlayerDropsEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        this.diceMap.remove(player.func_110124_au());
        this.slotMap.remove(player.func_110124_au());
        ItemStack stack = KeepDiceEvent.getBackpackStacks(player);
        int slot = KeepDiceEvent.getDice12Slot(player);
        if (stack.func_77973_b() instanceof ItemDice12 && slot != -1) {
            IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)player);
            handler.setStackInSlot(slot, ItemStack.field_190927_a);
            this.diceMap.put(player.func_110124_au(), stack);
            this.slotMap.put(player.func_110124_au(), slot);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerDeathLow(PlayerDropsEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (this.diceMap.containsKey(player.func_110124_au()) && this.slotMap.containsKey(player.func_110124_au())) {
            IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)player);
            handler.setStackInSlot(this.slotMap.get(player.func_110124_au()).intValue(), this.diceMap.get(player.func_110124_au()));
            this.diceMap.remove(player.func_110124_au());
            this.slotMap.remove(player.func_110124_au());
        }
    }

    public static ItemStack getBackpackStack(EntityPlayer player) {
        IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int x = 0; x < handler.getSlots(); ++x) {
            ItemStack stack = handler.getStackInSlot(x);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemDice12)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static int getDice12Slot(EntityPlayer player) {
        IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int x = 0; x < handler.getSlots(); ++x) {
            ItemStack stack = handler.getStackInSlot(x);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemDice12)) continue;
            return x;
        }
        return -1;
    }

    public static ItemStack getBackpackStacks(EntityPlayer player) {
        AtomicReference<ItemStack> backpack = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
        backpack.set(KeepDiceEvent.getBackpackStack(player));
        return backpack.get();
    }
}

