/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.foci;

import com.keletu.renaissance_core.entity.EntityPositiveBurstOrb;
import fr.wind_blade.isorropia.common.IsorropiaAPI;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.NodeSetting;
import thaumcraft.api.casters.Trajectory;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.common.lib.SoundsTC;

public class FocusPositiveBurst
extends FocusEffect {
    public String getResearch() {
        return "!FocusPositiveBurst";
    }

    public String getKey() {
        return "renaissance_core.POSITIVEBURST";
    }

    public Aspect getAspect() {
        return IsorropiaAPI.LUST;
    }

    public int getComplexity() {
        return this.getSettingValue("count") * 3 + (this.getSettingValue("function") == 0 ? 0 : 15);
    }

    public boolean execute(RayTraceResult target, Trajectory trajectory, float finalPower, int num) {
        int amount = this.getSettingValue("count");
        World world = this.getPackage().world;
        for (int i = 0; i < amount; ++i) {
            double offsetX = world.field_73012_v.nextDouble() - 0.5;
            double offsetY = world.field_73012_v.nextDouble() - 0.5;
            double offsetZ = world.field_73012_v.nextDouble() - 0.5;
            EntityPositiveBurstOrb orb = new EntityPositiveBurstOrb(world, target.field_72307_f.field_72450_a + offsetX, target.field_72307_f.field_72448_b + offsetY, target.field_72307_f.field_72449_c + offsetZ, this);
            double velocityX = (world.field_73012_v.nextDouble() - 0.5) * 0.2;
            double velocityY = (world.field_73012_v.nextDouble() - 0.5) * 0.2;
            double velocityZ = (world.field_73012_v.nextDouble() - 0.5) * 0.2;
            orb.field_70159_w = velocityX;
            orb.field_70181_x = velocityY;
            orb.field_70179_y = velocityZ;
            world.func_72838_d((Entity)orb);
        }
        return true;
    }

    public NodeSetting[] createSettings() {
        int[] function = new int[]{0, 1, 2};
        String[] functionkDesc = new String[]{"rcfocus.positive_burst.common", "rcfocus.positive_burst.vitaminize", "rcfocus.positive_burst.fulfillment"};
        return new NodeSetting[]{new NodeSetting("count", "rcfocus.positive_burst.count", (NodeSetting.INodeSettingType)new NodeSetting.NodeSettingIntRange(5, 10)), new NodeSetting("function", "rcfocus.positive_burst.function", (NodeSetting.INodeSettingType)new NodeSetting.NodeSettingIntList(function, functionkDesc))};
    }

    public void onCast(Entity caster) {
        caster.field_70170_p.func_184133_a(null, caster.func_180425_c().func_177984_a(), SoundsTC.ice, SoundCategory.PLAYERS, 0.25f, 1.0f + (float)(caster.field_70170_p.field_73012_v.nextGaussian() * 0.05));
    }

    @SideOnly(value=Side.CLIENT)
    public void renderParticleFX(World world, double x, double y, double z, double vx, double vy, double vz) {
        FXGeneric fb = new FXGeneric(world, x, y, z, vx + world.field_73012_v.nextGaussian() * 0.01, vy + world.field_73012_v.nextGaussian() * 0.01, vz + world.field_73012_v.nextGaussian() * 0.01);
        fb.func_187114_a((int)(10.0f + 10.0f * world.field_73012_v.nextFloat()));
        fb.func_70538_b(1.0f, 1.0f, 1.0f);
        fb.setAlphaF(new float[]{0.0f, 0.7f, 0.7f, 0.0f});
        fb.setGridSize(64);
        fb.setParticles(0, 1, 1);
        fb.setScale(new float[]{world.field_73012_v.nextFloat() * 2.0f, world.field_73012_v.nextFloat()});
        fb.setSlowDown(0.8);
        fb.setGravity((float)(world.field_73012_v.nextGaussian() * (double)0.1f));
        fb.setRandomMovementScale(0.0125f, 0.0125f, 0.0125f);
        fb.setRotationSpeed((float)world.field_73012_v.nextGaussian());
        ParticleEngine.addEffectWithDelay((World)world, (Particle)fb, (int)world.field_73012_v.nextInt(4));
    }
}

