/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.items;

import com.keletu.renaissance_core.RenaissanceCore;
import com.keletu.renaissance_core.blocks.TileDestabilizedCrystal;
import com.keletu.renaissance_core.client.particle.FXColoredLightning;
import com.keletu.renaissance_core.packet.PacketFXLightning;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.common.entities.EntityFluxRift;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.EntityUtils;

public class ItemVisConductor
extends Item {
    private static final Random rand = new Random(System.currentTimeMillis());
    long soundDelay = 0L;

    public ItemVisConductor() {
        this.field_77777_bU = 1;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase p, int time) {
        NBTTagCompound fociTag = stack.func_77978_p();
        if (fociTag == null) {
            fociTag = new NBTTagCompound();
        }
        RayTraceResult pos = BlockUtils.getTargetBlock((World)p.field_70170_p, (Entity)p, (boolean)false);
        if (fociTag.func_74764_b("blockX")) {
            int x = fociTag.func_74762_e("blockX");
            int y = fociTag.func_74762_e("blockY");
            int z = fociTag.func_74762_e("blockZ");
            BlockPos position = new BlockPos(x, y, z);
            if (p.func_70092_e((double)x, (double)y, (double)z) <= 64.0) {
                TileDestabilizedCrystal crystal = (TileDestabilizedCrystal)p.field_70170_p.func_175625_s(position);
                if (crystal != null) {
                    if (!crystal.aspect.equalsIgnoreCase(fociTag.func_74779_i("aspect"))) {
                        p.func_184597_cx();
                    }
                    if (!p.field_70170_p.field_72995_K && this.soundDelay < System.currentTimeMillis()) {
                        p.field_70170_p.func_184133_a(null, p.func_180425_c(), SoundsTC.jacobs, SoundCategory.PLAYERS, 0.5f, 1.0f + (rand.nextFloat() - rand.nextFloat()) * 0.2f);
                        this.soundDelay = System.currentTimeMillis() + 500L;
                    }
                    int potency = 3;
                    if (time % 3 == 0 && !p.field_70170_p.field_72995_K) {
                        crystal.capacity = MathHelper.func_76125_a((int)(crystal.capacity - (1 + potency)), (int)0, (int)Integer.MAX_VALUE);
                        p.field_70170_p.func_184138_a(position, p.field_70170_p.func_180495_p(position), p.field_70170_p.func_180495_p(position), 3);
                        crystal.func_70296_d();
                    }
                    if (p.field_70170_p.field_72995_K) {
                        int rgb = ((Aspect)Aspect.aspects.get(crystal.aspect)).getColor();
                        ItemVisConductor.shootLightning(p.field_70170_p, p, (float)x + 0.5f + (-0.5f + rand.nextFloat()), (float)y + 0.5f + (-0.5f + rand.nextFloat()), (float)z + 0.5f + (-0.5f + rand.nextFloat()), rgb);
                    }
                }
            } else {
                p.func_184597_cx();
            }
        } else if (pos != null && p.field_70170_p.func_175625_s(pos.func_178782_a()) instanceof TileDestabilizedCrystal) {
            TileDestabilizedCrystal crystal = (TileDestabilizedCrystal)p.field_70170_p.func_175625_s(pos.func_178782_a());
            if (crystal.aspect != null && crystal.capacity > 0) {
                p.field_70170_p.func_184138_a(pos.func_178782_a(), p.field_70170_p.func_180495_p(pos.func_178782_a()), p.field_70170_p.func_180495_p(pos.func_178782_a()), 3);
                crystal.func_70296_d();
                fociTag.func_74768_a("blockX", pos.func_178782_a().func_177958_n());
                fociTag.func_74768_a("blockY", pos.func_178782_a().func_177956_o());
                fociTag.func_74768_a("blockZ", pos.func_178782_a().func_177952_p());
                fociTag.func_74768_a("amount", crystal.capacity);
                fociTag.func_74778_a("aspect", crystal.aspect);
                stack.func_77982_d(fociTag);
            }
        }
    }

    public void func_77615_a(ItemStack wandstack, World world, EntityLivingBase entity, int count) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        NBTTagCompound fociTag = wandstack.func_77978_p();
        if (fociTag == null) {
            fociTag = new NBTTagCompound();
        }
        if (fociTag.func_74764_b("blockX")) {
            int blockZ;
            int blockY;
            int blockX = fociTag.func_74762_e("blockX");
            BlockPos pos = new BlockPos(blockX, blockY = fociTag.func_74762_e("blockY"), blockZ = fociTag.func_74762_e("blockZ"));
            if (player.field_70170_p.func_175625_s(pos) instanceof TileDestabilizedCrystal) {
                TileDestabilizedCrystal crystal = (TileDestabilizedCrystal)player.field_70170_p.func_175625_s(pos);
                if (crystal == null) {
                    return;
                }
                Entity look = EntityUtils.getPointedEntity((World)player.field_70170_p, (Entity)player, (double)0.0, (double)32.0, (float)1.1f, (boolean)true);
                if (look == null) {
                    if (!world.field_72995_K) {
                        player.field_70170_p.func_175698_g(pos);
                        player.field_70170_p.func_175713_t(pos);
                        boolean var2 = player.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
                        player.field_70170_p.func_72876_a(null, (double)blockX, (double)blockY, (double)blockZ, 2.0f, var2);
                    }
                } else if (ThaumcraftCapabilities.knowsResearch((EntityPlayer)player, (String[])new String[]{"DEMATUPGRADE"})) {
                    int amount = fociTag.func_74762_e("amount");
                    int rgb = ((Aspect)Aspect.aspects.get(fociTag.func_74779_i("aspect"))).getColor();
                    if (look instanceof EntityLivingBase && !world.field_72995_K) {
                        look.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player).func_82726_p(), (float)(amount - crystal.capacity) / 3.0f);
                        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundsTC.shock, SoundCategory.PLAYERS, 0.8f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
                        RenaissanceCore.packetInstance.sendToAllAround((IMessage)new PacketFXLightning((float)look.field_70165_t, (float)look.field_70163_u + 0.5f, (float)look.field_70161_v, (float)player.field_70165_t, (float)player.field_70163_u - 0.5f, (float)player.field_70161_v, rgb, 0.2f), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 32.0));
                    }
                    if (crystal.aspect.equals(Aspect.AURA.getTag()) && look instanceof EntityFluxRift && !world.field_72995_K) {
                        ((EntityFluxRift)look).setRiftSize(((EntityFluxRift)look).getRiftSize() - amount * 4);
                        RenaissanceCore.packetInstance.sendToAllAround((IMessage)new PacketFXLightning((float)look.field_70165_t, (float)look.field_70163_u + 0.5f, (float)look.field_70161_v, (float)player.field_70165_t, (float)player.field_70163_u + 0.5f, (float)player.field_70161_v, rgb, 0.2f), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 32.0));
                    }
                }
                player.field_70170_p.func_184138_a(crystal.func_174877_v(), world.func_180495_p(pos), world.func_180495_p(pos), 3);
                crystal.func_70296_d();
            }
            fociTag.func_82580_o("blockX");
            fociTag.func_82580_o("blockY");
            fociTag.func_82580_o("blockZ");
            fociTag.func_82580_o("amount");
            fociTag.func_82580_o("aspect");
        }
    }

    public static void shootLightning(World world, EntityLivingBase entityplayer, double xx, double yy, double zz, int rgb) {
        double px = entityplayer.field_70165_t;
        double py = entityplayer.field_70163_u;
        double pz = entityplayer.field_70161_v;
        py = entityplayer.func_174813_aQ().field_72338_b + (double)(entityplayer.field_70131_O / 2.0f) + 0.25;
        px += (double)(-MathHelper.func_76134_b((float)(entityplayer.field_70177_z / 180.0f * 3.141593f)) * 0.06f);
        py += (double)-0.06f;
        pz += (double)(-MathHelper.func_76126_a((float)(entityplayer.field_70177_z / 180.0f * 3.141593f)) * 0.06f);
        py = entityplayer.func_174813_aQ().field_72338_b + (double)(entityplayer.field_70131_O / 2.0f) + 0.25;
        Vec3d vec3d = entityplayer.func_70676_i(1.0f);
        FXColoredLightning bolt = new FXColoredLightning(world, px += vec3d.field_72450_a * 0.3, py += vec3d.field_72448_b * 0.3, pz += vec3d.field_72449_c * 0.3, xx, yy, zz, world.field_73012_v.nextLong(), 6, 0.5f, 8);
        bolt.defaultFractal();
        bolt.setType(10);
        bolt.setWidth(0.125f);
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        bolt.func_70538_b((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f);
        bolt.finalizeBolt();
    }
}

