/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.module.botania;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.client.lib.UtilsFX;
import vazkii.botania.api.internal.IGuiLexiconEntry;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lexicon.LexiconData;
import vazkii.botania.common.lexicon.page.PageRecipe;

public class PageCrucibleRecipe
extends PageRecipe {
    private static final ResourceLocation elvenTradeOverlay = new ResourceLocation("renaissance_core", "textures/gui/crucibleoverlay.png");
    final List<CrucibleRecipe> recipes;
    int ticksElapsed = 0;
    int recipeAt = 0;

    public PageCrucibleRecipe(String unlocalizedName, List<CrucibleRecipe> recipes) {
        super(unlocalizedName);
        this.recipes = recipes;
    }

    public PageCrucibleRecipe(String unlocalizedName, CrucibleRecipe recipe) {
        this(unlocalizedName, Collections.singletonList(recipe));
    }

    @SideOnly(value=Side.CLIENT)
    public void renderRecipe(IGuiLexiconEntry gui, int mx, int my) {
        CrucibleRecipe recipe = this.recipes.get(this.recipeAt);
        TextureManager render = Minecraft.func_71410_x().field_71446_o;
        render.func_110577_a(elvenTradeOverlay);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((GuiScreen)gui).func_73729_b(gui.getLeft(), gui.getTop(), 0, 0, gui.getWidth(), gui.getHeight());
        GlStateManager.func_179084_k();
        this.renderItemAtOutputPos(gui, 0, 0, recipe.getRecipeOutput());
        ItemStack stk = recipe.getCatalyst().func_193365_a()[0];
        int x = 20;
        for (Aspect aspect : recipe.getAspects().getAspects()) {
            UtilsFX.drawTag((int)(gui.getLeft() + x), (int)(gui.getTop() + 50), (Aspect)aspect, (float)recipe.getAspects().getAmount(aspect), (int)0, (double)0.0);
            x += 17;
        }
        this.renderItemAtInputPos(gui, 0, stk);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItemAtInputPos(IGuiLexiconEntry gui, int x, ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        if ((stack = stack.func_77946_l()).func_77952_i() == Short.MAX_VALUE) {
            stack.func_77964_b(0);
        }
        int xPos = gui.getLeft() + x * 20 + 45;
        int yPos = gui.getTop() + 14;
        ItemStack stack1 = stack.func_77946_l();
        if (stack1.func_77952_i() == -1) {
            stack1.func_77964_b(0);
        }
        this.renderItem(gui, xPos, yPos, stack1, false);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItemAtOutputPos(IGuiLexiconEntry gui, int x, int y, ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        if ((stack = stack.func_77946_l()).func_77952_i() == Short.MAX_VALUE) {
            stack.func_77964_b(0);
        }
        int xPos = gui.getLeft() + x * 20 + 94;
        int yPos = gui.getTop() + y * 20 + 52;
        ItemStack stack1 = stack.func_77946_l();
        if (stack1.func_77952_i() == -1) {
            stack1.func_77964_b(0);
        }
        this.renderItem(gui, xPos, yPos, stack1, false);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        if (GuiScreen.func_146272_n()) {
            return;
        }
        if (this.ticksElapsed % 20 == 0) {
            ++this.recipeAt;
            if (this.recipeAt == this.recipes.size()) {
                this.recipeAt = 0;
            }
        }
        ++this.ticksElapsed;
    }

    public List<ItemStack> getDisplayedRecipes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (CrucibleRecipe r : this.recipes) {
            list.add(r.getRecipeOutput());
        }
        return list;
    }

    public static void init() {
        LexiconData.flowers.pages.remove(7);
        LexiconData.flowers.pages.set(7, new PageCrucibleRecipe("renaissance_core.research", new CrucibleRecipe("BASICBOTABY", new ItemStack(ModItems.fertilizer, 3), (Object)new ItemStack(Items.field_151100_aR, 1, 15), new AspectList().add(Aspect.EXCHANGE, 10).add(Aspect.PLANT, 10))));
    }
}

