/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.module.botania;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.client.lib.UtilsFX;
import vazkii.botania.api.internal.IGuiLexiconEntry;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lexicon.LexiconData;
import vazkii.botania.common.lexicon.page.PageRecipe;
import vazkii.botania.common.lexicon.page.PageText;

public class PageInfusionRecipe<T extends InfusionRecipe>
extends PageRecipe {
    private static final ResourceLocation petalOverlay = new ResourceLocation("renaissance_core", "textures/gui/infusionoverlay.png");
    private final List<T> recipes;
    private int ticksElapsed = 0;
    private int recipeAt = 0;
    public static final int SPACE = 22;

    public PageInfusionRecipe(String unlocalizedName, List<T> recipes) {
        super(unlocalizedName);
        this.recipes = recipes;
    }

    public PageInfusionRecipe(String unlocalizedName, T recipe) {
        this(unlocalizedName, Collections.singletonList(recipe));
    }

    @SideOnly(value=Side.CLIENT)
    public void renderRecipe(IGuiLexiconEntry gui, int mx, int my) {
        InfusionRecipe recipe = (InfusionRecipe)this.recipes.get(this.recipeAt);
        TextureManager render = Minecraft.func_71410_x().field_71446_o;
        int twidth = gui.getWidth() - 30;
        int tx = gui.getLeft() + 15;
        int ty = gui.getTop() + 5;
        String inst = TextFormatting.DARK_GRAY + new TextComponentTranslation("tc.inst", new Object[0]).func_150254_d() + new TextComponentTranslation("tc.inst." + Math.min(recipe.getInstability((EntityPlayer)Minecraft.func_71410_x().field_71439_g, null, null) / 4, 5), new Object[0]).func_150260_c();
        PageText.renderText((int)tx, (int)ty, (int)twidth, (int)gui.getHeight(), (String)inst);
        this.renderItemAtGridPos(gui, 3, 0, (ItemStack)recipe.getRecipeOutput(), false);
        this.renderItemAtGridPos(gui, 2, 1, recipe.getRecipeInput().func_193365_a()[0], false);
        NonNullList inputs = recipe.getComponents();
        int degreePerInput = (int)(360.0f / (float)inputs.size());
        float currentDegree = ConfigHandler.lexiconRotatingItems ? (GuiScreen.func_146272_n() ? (float)this.ticksElapsed : (float)this.ticksElapsed + ClientTickHandler.partialTicks) : 0.0f;
        int inputIndex = this.ticksElapsed / 40;
        for (Object obj : inputs) {
            Object input = obj;
            if (input instanceof String) {
                NonNullList list = OreDictionary.getOres((String)((String)input));
                int size = list.size();
                input = list.get(size - inputIndex % size - 1);
            }
            this.renderIngredientAtAngle(gui, currentDegree, input);
            currentDegree += (float)degreePerInput;
        }
        int x = 13;
        for (Aspect aspect : recipe.getAspects().getAspects()) {
            UtilsFX.drawTag((int)(gui.getLeft() + x), (int)(gui.getTop() + 110), (Aspect)aspect, (float)recipe.getAspects().getAmount(aspect), (int)0, (double)0.0);
            x += 17;
        }
        render.func_110577_a(petalOverlay);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((GuiScreen)gui).func_73729_b(gui.getLeft(), gui.getTop(), 0, 0, gui.getWidth(), gui.getHeight());
        GlStateManager.func_179084_k();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderIngredientAtAngle(IGuiLexiconEntry gui, float angle, Object stack) {
        ItemStack stk = ItemStack.field_190927_a;
        if (stack instanceof OreIngredient) {
            stk = ((OreIngredient)stack).func_193365_a()[0];
        } else if (stack instanceof Ingredient) {
            stk = ((Ingredient)stack).func_193365_a()[0];
        }
        if (!stk.func_190926_b()) {
            ItemStack workStack = stk.func_77946_l();
            if (workStack.func_77952_i() == Short.MAX_VALUE || workStack.func_77952_i() == -1) {
                workStack.func_77964_b(0);
            }
            int radius = 32;
            double xPos = (double)gui.getLeft() + Math.cos((double)(angle -= 90.0f) * Math.PI / 180.0) * (double)radius + (double)(gui.getWidth() / 2) - 8.0;
            double yPos = (double)gui.getTop() + Math.sin((double)angle * Math.PI / 180.0) * (double)radius + 53.0;
            this.renderItem(gui, xPos, yPos, workStack, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        if (GuiScreen.func_146272_n()) {
            return;
        }
        if (this.ticksElapsed % 20 == 0) {
            ++this.recipeAt;
            if (this.recipeAt == this.recipes.size()) {
                this.recipeAt = 0;
            }
        }
        ++this.ticksElapsed;
    }

    public List<ItemStack> getDisplayedRecipes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (InfusionRecipe r : this.recipes) {
            list.add((ItemStack)r.getRecipeOutput());
        }
        return list;
    }

    public static void init() {
        LexiconData.brewery.pages.set(2, new PageInfusionRecipe<InfusionRecipe>("renaissance_core.research", new InfusionRecipe("PLANTBREWERY", (Object)new ItemStack(ModBlocks.brewery), 7, new AspectList().add(Aspect.MAN, 30).add(Aspect.MECHANISM, 50).add(Aspect.ENTROPY, 30), (Object)Items.field_151067_bt, new Object[]{"ingotGold", new ItemStack(ModBlocks.manaGlass), new ItemStack(ModFluffBlocks.livingrockSlab), new ItemStack(ModFluffBlocks.livingrockSlab), new ItemStack(ModFluffBlocks.livingrockSlab), new ItemStack(ModBlocks.manaGlass), "ingotGold", new ItemStack(ModBlocks.manaGlass), new ItemStack(ModFluffBlocks.livingrockSlab), new ItemStack(ModFluffBlocks.livingrockSlab), new ItemStack(ModFluffBlocks.livingrockSlab), new ItemStack(ModBlocks.manaGlass)})));
        LexiconData.runicAltar.pages.set(3, new PageInfusionRecipe<InfusionRecipe>("renaissance_core.research", new InfusionRecipe("BOTANYALTAR@3", (Object)new ItemStack(ModBlocks.runeAltar), 8, new AspectList().add(Aspect.AURA, 60).add(Aspect.CRAFT, 60).add(Aspect.PLANT, 100).add(Aspect.EXCHANGE, 30), (Object)new ItemStack(BlocksTC.infusionMatrix), new Object[]{"livingrock", "ingotManasteel", "gemPrismarine", "manaPearl", "livingrock", "ingotManasteel", "gemPrismarine", "manaPearl"})));
        LexiconData.terrasteel.pages.set(1, new PageInfusionRecipe<InfusionRecipe>("renaissance_core.research", new InfusionRecipe("TERRAPLATE@3", (Object)new ItemStack(ModBlocks.terraPlate), 12, new AspectList().add(Aspect.AIR, 125).add(Aspect.WATER, 125).add(Aspect.FIRE, 125).add(Aspect.EARTH, 125).add(Aspect.ENTROPY, 125).add(Aspect.ORDER, 125).add(Aspect.MAGIC, 75), (Object)new ItemStack(ModBlocks.runeAltar), new Object[]{"runeWaterB", "runeFireB", "runeEarthB", "runeAirB", "runeSpringB", "runeSummerB", "runeAutumnB", "runeWinterB", "runeManaB", "runeLustB", "runeGluttonyB", "runeGreedB", "runeSlothB", "runeWrathB", "runeEnvyB", "runePrideB"})));
        LexiconData.terraBlade.pages.set(1, new PageInfusionRecipe<InfusionRecipe>("renaissance_core.research", new InfusionRecipe("TERRASWORD", (Object)new ItemStack(ModItems.terraSword), 8, new AspectList().add(Aspect.EARTH, 110).add(Aspect.EXCHANGE, 75).add(Aspect.LIGHT, 75).add(Aspect.AVERSION, 50), (Object)ItemsTC.elementalSword, new Object[]{"ingotTerrasteel", "ingotTerrasteel"})));
        LexiconData.terraPick.pages.set(5, new PageInfusionRecipe<InfusionRecipe>("renaissance_core.research", new InfusionRecipe("TERRAPICK", (Object)new ItemStack(ModItems.terraPick), 8, new AspectList().add(Aspect.EARTH, 110).add(Aspect.EXCHANGE, 75).add(Aspect.ENTROPY, 75).add(Aspect.TOOL, 50), (Object)ItemsTC.elementalPick, new Object[]{"ingotTerrasteel", "ingotTerrasteel"})));
        LexiconData.terraAxe.pages.set(1, new PageInfusionRecipe<InfusionRecipe>("renaissance_core.research", new InfusionRecipe("TERRAAXE", (Object)new ItemStack(ModItems.terraAxe), 8, new AspectList().add(Aspect.EARTH, 110).add(Aspect.PLANT, 75).add(Aspect.ENTROPY, 75).add(Aspect.TOOL, 50), (Object)ItemsTC.elementalAxe, new Object[]{"ingotTerrasteel", "ingotTerrasteel"})));
        LexiconData.alfhomancyIntro.pages.set(2, new PageInfusionRecipe<InfusionRecipe>("renaissance_core.research", new InfusionRecipe("ALFPORTAL", (Object)new ItemStack(ModBlocks.alfPortal), 16, new AspectList().add(Aspect.VOID, 125).add(Aspect.EXCHANGE, 125).add(Aspect.PLANT, 125), (Object)new ItemStack(ModBlocks.alchemyCatalyst), new Object[]{"ingotVoid", "ingotTerrasteel", new ItemStack(ModBlocks.livingwood, 1, 5), new ItemStack(BlocksTC.metalAlchemical), "glowstone", "ingotVoid", "ingotTerrasteel", new ItemStack(ModBlocks.livingwood, 1, 5), new ItemStack(BlocksTC.metalAlchemical), "glowstone"})));
        LexiconData.gaiaRitual.pages.set(1, new PageInfusionRecipe<InfusionRecipe>("renaissance_core.research", new InfusionRecipe("WORLDOFGAIA", (Object)new ItemStack(ModBlocks.pylon, 1, 2), 66, new AspectList().add(Aspect.DARKNESS, 66).add(Aspect.EXCHANGE, 66).add(Aspect.TRAP, 66).add(Aspect.CRYSTAL, 66).add(Aspect.PLANT, 66), (Object)new ItemStack(ModBlocks.pylon, 1, 0), new Object[]{new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thaumicaugmentation", "material")), 1, 5), "elvenDragonstone", new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thaumicaugmentation", "material")), 1, 5), "elvenDragonstone", new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thaumicaugmentation", "material")), 1, 5), "elvenDragonstone"})));
    }
}

