/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.events;

import com.keletu.renaissance_core.ConfigsRC;
import com.keletu.renaissance_core.RenaissanceCore;
import com.keletu.renaissance_core.capability.CapThaumicConcilium;
import com.keletu.renaissance_core.capability.ICapConcilium;
import com.keletu.renaissance_core.capability.IT12Capability;
import com.keletu.renaissance_core.capability.RCCapabilities;
import com.keletu.renaissance_core.capability.T12Capability;
import com.keletu.renaissance_core.entity.EntityCrimsonPaladin;
import com.keletu.renaissance_core.entity.EntityDissolved;
import com.keletu.renaissance_core.entity.EntityMadThaumaturge;
import com.keletu.renaissance_core.entity.EntityStrayedMirror;
import com.keletu.renaissance_core.items.ItemPontifexRobe;
import com.keletu.renaissance_core.packet.PacketSyncCapability;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.common.entities.monster.EntityBrainyZombie;
import thaumcraft.common.entities.monster.EntityGiantBrainyZombie;
import thaumcraft.common.entities.monster.cult.EntityCultist;
import thaumcraft.common.entities.monster.cult.EntityCultistKnight;
import thaumcraft.common.lib.SoundsTC;

@Mod.EventBusSubscriber(modid="renaissance_core")
public class EventHandlerEntity {
    public static final HashMap<EntityPlayer, Boolean> etherealsClient = new HashMap();
    public static final HashMap<EntityPlayer, Boolean> etherealsServer = new HashMap();

    @SubscribeEvent
    public static void playerUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            HashMap<EntityPlayer, Boolean> ethereals;
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ICapConcilium capabilities = ICapConcilium.get(player);
            HashMap<EntityPlayer, Boolean> hashMap = ethereals = !player.field_70170_p.field_72995_K ? etherealsServer : etherealsClient;
            if (capabilities.isEthereal()) {
                player.field_70145_X = true;
                if (!player.func_70093_af() || !player.func_70093_af() && !player.field_71075_bZ.field_75101_c) {
                    player.field_70181_x = 0.0;
                }
            } else if (ethereals.getOrDefault(player, false).booleanValue()) {
                player.field_70145_X = false;
            }
            ethereals.put(player, capabilities.isEthereal());
        }
    }

    @SubscribeEvent
    public static void tickHandler(TickEvent.PlayerTickEvent event) {
        ICapConcilium iconcilium;
        EntityPlayer player = event.player;
        RenaissanceCore.proxy.sendLocalMovementData((EntityLivingBase)player);
        ICapConcilium capabilities = ICapConcilium.get(event.player);
        if (capabilities != null && !player.field_70170_p.field_72995_K) {
            if (capabilities.getPontifexRobeToggle() && !ItemPontifexRobe.isFullSet(player)) {
                capabilities.setEthereal(false);
                capabilities.setPontifexRobeToggle(false);
                capabilities.sync();
            }
            if (capabilities.getChainedTime() > 0) {
                capabilities.setChainedTime(capabilities.getChainedTime() - 1);
                capabilities.sync();
            }
        }
        if (event.phase == TickEvent.Phase.END || event.player.field_70170_p.field_72995_K) {
            return;
        }
        IT12Capability it12 = IT12Capability.get(event.player);
        if (it12 != null) {
            it12.setLocationCorrect();
            EventHandlerEntity.syncToClientT12(event.player);
        }
        if ((iconcilium = ICapConcilium.get(event.player)) != null) {
            iconcilium.setLocationCorrect();
            EventHandlerEntity.syncToClientConcilium(event.player);
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        if ((event.getEntity() instanceof EntityBrainyZombie || event.getEntity() instanceof EntityGiantBrainyZombie) && event.getWorld().field_73012_v.nextInt(100) > ConfigsRC.madThaumaturgeReplacesBrainyZombieChance && !event.getWorld().field_72995_K) {
            EntityMadThaumaturge madThaumaturge = new EntityMadThaumaturge(event.getWorld());
            madThaumaturge.func_70012_b(event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, event.getWorld().field_73012_v.nextFloat() * 360.0f, 0.0f);
            madThaumaturge.func_180482_a(event.getWorld().func_175649_E(event.getEntity().func_180425_c()), null);
            event.getEntity().func_70106_y();
            event.getWorld().func_72838_d((Entity)madThaumaturge);
        }
        if (event.getEntity() instanceof EntityCultistKnight && event.getWorld().field_73012_v.nextInt(100) > ConfigsRC.crimsonPaladinReplacesCultistWarriorChance && !event.getWorld().field_72995_K) {
            EntityCrimsonPaladin paladin = new EntityCrimsonPaladin(event.getWorld());
            paladin.func_70012_b(event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, event.getWorld().field_73012_v.nextFloat() * 360.0f, 0.0f);
            paladin.func_180482_a(event.getWorld().func_175649_E(event.getEntity().func_180425_c()), null);
            event.getEntity().func_70106_y();
            event.getWorld().func_72838_d((Entity)paladin);
        }
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            ICapConcilium capabilities = ICapConcilium.get(event.player);
            capabilities.setPontifexRobeToggle(false);
            capabilities.setEthereal(false);
            capabilities.sync();
        }
    }

    @SubscribeEvent
    public static void attachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("renaissance_core", "canpickoff_t12"), (ICapabilityProvider)new T12Capability.Provider((EntityPlayer)event.getObject()));
            event.addCapability(new ResourceLocation("renaissance_core", "thaumic_concilium"), (ICapabilityProvider)new CapThaumicConcilium.Provider((EntityPlayer)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof EntityCultist && event.getTarget() instanceof EntityPlayer && ItemPontifexRobe.isFullSet((EntityPlayer)event.getTarget())) {
            ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        List list;
        if (!event.getEntityPlayer().field_70170_p.field_72995_K && event.getTarget() != null && ItemPontifexRobe.isFullSet(event.getEntityPlayer()) && !(list = event.getEntityPlayer().field_70170_p.func_72872_a(EntityCultist.class, event.getEntityPlayer().func_174813_aQ().func_72321_a(32.0, 32.0, 32.0).func_72321_a(-32.0, -32.0, -32.0))).isEmpty()) {
            int potency = MathHelper.func_76125_a((int)1, (int)1, (int)200);
            int regen = MathHelper.func_76125_a((int)1, (int)1, (int)200);
            for (EntityCultist cultist : list) {
                if (!(event.getTarget() instanceof EntityLivingBase) || !cultist.func_184222_aU() || event.getTarget() instanceof EntityCultist) continue;
                cultist.func_70624_b((EntityLivingBase)event.getTarget());
                cultist.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 100, potency));
                cultist.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100, regen));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            EventHandlerEntity.syncToClientT12(event.player);
            EventHandlerEntity.syncToClientConcilium(event.player);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        ICapConcilium capability1;
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        IT12Capability capability = (IT12Capability)player.getCapability(RCCapabilities.PICK_OFF_T12_CAP, null);
        if (capability != null) {
            NBTTagCompound data = capability.serializeNBT();
            player.getEntityData().func_74782_a("CanPickOffT12", (NBTBase)data);
        }
        if ((capability1 = (ICapConcilium)player.getCapability(RCCapabilities.CONCILIUM, null)) != null) {
            NBTTagCompound data = capability1.serializeNBT();
            player.getEntityData().func_74782_a("ThaumicConcilium", (NBTBase)data);
        }
    }

    @SubscribeEvent
    public static void onLivingHeal(LivingHealEvent event) {
        EntityPlayer player;
        ICapConcilium capabilities;
        EntityLivingBase ent = event.getEntityLiving();
        if (ent instanceof EntityPlayer && (capabilities = ICapConcilium.get(player = (EntityPlayer)ent)) != null && capabilities.isEthereal()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer original = event.getOriginal();
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        IT12Capability oldCap = (IT12Capability)original.getCapability(RCCapabilities.PICK_OFF_T12_CAP, null);
        IT12Capability newCap = (IT12Capability)player.getCapability(RCCapabilities.PICK_OFF_T12_CAP, null);
        if (oldCap != null && newCap != null) {
            NBTTagCompound data;
            if (event.isWasDeath()) {
                data = original.getEntityData().func_74775_l("CanPickOffT12");
                newCap.deserializeNBT(data);
            } else {
                data = oldCap.serializeNBT();
                newCap.deserializeNBT(data);
            }
            EventHandlerEntity.syncToClientT12(player);
        }
        ICapConcilium oldCapc = (ICapConcilium)original.getCapability(RCCapabilities.CONCILIUM, null);
        ICapConcilium newCapc = (ICapConcilium)player.getCapability(RCCapabilities.CONCILIUM, null);
        if (oldCapc != null && newCapc != null) {
            if (event.isWasDeath()) {
                NBTTagCompound data = original.getEntityData().func_74775_l("ThaumicConcilium");
                newCapc.deserializeNBT(data);
            } else {
                NBTTagCompound data = oldCapc.serializeNBT();
                newCapc.deserializeNBT(data);
            }
            EventHandlerEntity.syncToClientConcilium(player);
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        EntityPlayer player;
        ICapConcilium capabilities;
        if (event.getEntityLiving() instanceof EntityDissolved && !event.getSource().field_76373_n.equals("outOfWorld") && !event.getSource().field_76373_n.equals("inWall")) {
            event.setCanceled(true);
        }
        if (event.getEntityLiving() instanceof EntityStrayedMirror && event.getSource().field_76373_n.equals("magic")) {
            event.setCanceled(true);
        }
        if (event.getEntityLiving() instanceof EntityPlayer && (capabilities = ICapConcilium.get(player = (EntityPlayer)event.getEntityLiving())) != null && !player.field_71075_bZ.field_75098_d && capabilities.isEthereal()) {
            event.setCanceled(true);
        }
    }

    private static void deflectProjectile(Entity projectile) {
        double bounceStrength = -1.0;
        projectile.field_70159_w *= bounceStrength;
        projectile.field_70181_x *= bounceStrength;
        projectile.field_70179_y *= bounceStrength;
        projectile.field_70133_I = true;
        projectile.field_70170_p.func_184133_a(null, projectile.func_180425_c(), SoundsTC.fly, SoundCategory.HOSTILE, 1.0f, 1.0f);
    }

    @SubscribeEvent
    public static void reflectArrowEvent(ProjectileImpactEvent.Arrow event) {
        EntityArrow projectile = event.getArrow();
        if (projectile.func_130014_f_().field_72995_K) {
            return;
        }
        Entity entity = event.getRayTraceResult().field_72308_g;
        if (event.getEntity() != null && entity instanceof EntityStrayedMirror) {
            EventHandlerEntity.deflectProjectile((Entity)projectile);
            projectile.field_70250_c = entity;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void reflectFireballEvent(ProjectileImpactEvent.Fireball event) {
        EntityFireball projectile = event.getFireball();
        if (projectile.func_130014_f_().field_72995_K) {
            return;
        }
        Entity entity = event.getRayTraceResult().field_72308_g;
        if (event.getEntity() != null && entity instanceof EntityStrayedMirror) {
            EventHandlerEntity.deflectProjectile((Entity)projectile);
            double bounceStrength = -1.0;
            projectile.field_70232_b *= bounceStrength;
            projectile.field_70233_c *= bounceStrength;
            projectile.field_70230_d *= bounceStrength;
            projectile.field_70235_a = (EntityLivingBase)entity;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void reflectThrowableEvent(ProjectileImpactEvent.Throwable event) {
        EntityThrowable projectile = event.getThrowable();
        if (projectile.func_130014_f_().field_72995_K) {
            return;
        }
        Entity entity = event.getRayTraceResult().field_72308_g;
        if (event.getEntity() != null && entity instanceof EntityStrayedMirror) {
            EventHandlerEntity.deflectProjectile((Entity)projectile);
            event.setCanceled(true);
        }
    }

    private static void syncToClientT12(EntityPlayer player) {
        IT12Capability capability;
        if (player instanceof EntityPlayerMP && (capability = (IT12Capability)player.getCapability(RCCapabilities.PICK_OFF_T12_CAP, null)) != null) {
            NBTTagCompound data = capability.serializeNBT();
            RenaissanceCore.packetInstance.sendTo((IMessage)new PacketSyncCapability(data, 0), (EntityPlayerMP)player);
        }
    }

    public static void syncToClientConcilium(EntityPlayer player) {
        ICapConcilium capability;
        if (player instanceof EntityPlayerMP && (capability = (ICapConcilium)player.getCapability(RCCapabilities.CONCILIUM, null)) != null) {
            NBTTagCompound data = capability.serializeNBT();
            RenaissanceCore.packetInstance.sendTo((IMessage)new PacketSyncCapability(data, 1), (EntityPlayerMP)player);
        }
    }
}

