/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.items;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.render.IRenderBauble;
import com.keletu.renaissance_core.ConfigsRC;
import com.keletu.renaissance_core.capability.IT12Capability;
import com.keletu.renaissance_core.events.CursedEvents;
import com.keletu.renaissance_core.items.RCItems;
import com.keletu.renaissance_core.util.TCVec3;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.items.IVisDiscountGear;
import thaumcraft.client.lib.obj.AdvancedModelLoader;
import thaumcraft.client.lib.obj.IModelCustom;
import thaumcraft.common.blocks.world.taint.ITaintBlock;

public class ItemDice12
extends Item
implements IBauble,
IVisDiscountGear,
IRenderBauble {
    public int rad;
    public int rad1 = 0;
    private final Map<ItemStack, IModelCustom> diceModels = new ConcurrentHashMap<ItemStack, IModelCustom>();

    public ItemDice12() {
        this.field_77777_bU = 1;
    }

    public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return player instanceof EntityPlayer && !CursedEvents.hasThaumiumCursed((EntityPlayer)player);
    }

    public boolean canUnequip(ItemStack stack, EntityLivingBase living) {
        return living instanceof EntityPlayer && (((EntityPlayer)living).func_184812_l_() || IT12Capability.get((EntityPlayer)living).getCanTakeOffT12());
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
        IT12Capability.get((EntityPlayer)player).setCanPickOffT12(false);
    }

    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.TRINKET;
    }

    public int getVisDiscount(ItemStack itemStack, EntityPlayer entityPlayer) {
        return ConfigsRC.cursedVisIncreasePercentage;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        list.add(I18n.func_135052_a((String)"tooltip.dice12.tip1", (Object[])new Object[0]));
        if (Minecraft.func_71410_x().field_71439_g != null) {
            if (BaublesApi.isBaubleEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (Item)this) != -1 || !IT12Capability.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getCanTakeOffT12()) {
                list.add(I18n.func_135052_a((String)"tooltip.dice12.tip2", (Object[])new Object[0]));
            }
            if (BaublesApi.isBaubleEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (Item)this) == -1 && !IT12Capability.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getCanTakeOffT12()) {
                list.add(I18n.func_135052_a((String)"tooltip.dice12.tip3", (Object[])new Object[0]));
            }
            if (BaublesApi.isBaubleEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (Item)this) != -1 && !IT12Capability.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getCanTakeOffT12()) {
                list.add(I18n.func_135052_a((String)"tooltip.dice12.tip4", (Object[])new Object[0]));
            }
        }
        list.add("");
        if (GuiScreen.func_146272_n()) {
            list.add(I18n.func_135052_a((String)"tooltip.dice12.tooltip1", (Object[])new Object[0]));
            list.add(I18n.func_135052_a((String)"tooltip.dice12.tooltip2", (Object[])new Object[0]));
            list.add(I18n.func_135052_a((String)"tooltip.dice12.tooltip3", (Object[])new Object[0]));
            list.add(I18n.func_135052_a((String)"tooltip.dice12.tooltip4", (Object[])new Object[0]));
            list.add(I18n.func_135052_a((String)"tooltip.dice12.tooltip5", (Object[])new Object[0]));
            list.add(I18n.func_135052_a((String)"tooltip.dice12.tooltip6", (Object[])new Object[0]));
            if (!(Minecraft.func_71410_x().field_71439_g == null || BaublesApi.isBaubleEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (Item)this) == -1 && IT12Capability.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getCanTakeOffT12())) {
                list.add("");
                list.add(I18n.func_135052_a((String)"tooltip.dice12.tooltip7", (Object[])new Object[0]));
                list.add(I18n.func_135052_a((String)"tooltip.dice12.tooltip8", (Object[])new Object[0]));
                list.add(I18n.func_135052_a((String)"tooltip.dice12.tooltip9", (Object[])new Object[0]));
                list.add(I18n.func_135052_a((String)"tooltip.dice12.tooltip10", (Object[])new Object[0]));
                list.add(I18n.func_135052_a((String)"tooltip.dice12.tooltip11", (Object[])new Object[0]));
                list.add(I18n.func_135052_a((String)"tooltip.dice12.tooltip12", (Object[])new Object[0]));
            }
        } else {
            list.add(I18n.func_135052_a((String)"tooltip.dice12.holdShift", (Object[])new Object[0]));
        }
        list.add("");
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return RCItems.rarityEric;
    }

    public void onWornTick(ItemStack stack, EntityLivingBase livingPlayer) {
        if (livingPlayer.field_70170_p.field_72995_K || !(livingPlayer instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)livingPlayer;
        TCVec3 vsource = TCVec3.createVectorHelper((double)player.func_180425_c().func_177958_n() + 0.5, (double)player.func_180425_c().func_177956_o() + 0.5, (double)player.func_180425_c().func_177952_p() + 0.5);
        for (int q = 1; q < 8; ++q) {
            TCVec3 vtar = TCVec3.createVectorHelper(q, 0.0, 0.0);
            vtar.rotateAroundZ((float)this.rad1 / 180.0f * (float)Math.PI);
            vtar.rotateAroundY((float)this.rad / 180.0f * (float)Math.PI);
            TCVec3 vres1 = vsource.addVector(vtar.xCoord, vtar.yCoord, vtar.zCoord);
            TCVec3 vres2 = vsource.addVector(-vtar.xCoord, -vtar.yCoord, -vtar.zCoord);
            BlockPos t1 = new BlockPos(MathHelper.func_76128_c((double)vres1.xCoord), MathHelper.func_76128_c((double)vres1.yCoord), MathHelper.func_76128_c((double)vres1.zCoord));
            while (player.field_70170_p.func_175623_d(t1) && t1.func_177956_o() > 0) {
                t1 = t1.func_177977_b();
            }
            BlockPos t2 = new BlockPos(MathHelper.func_76128_c((double)vres2.xCoord), MathHelper.func_76128_c((double)vres2.yCoord), MathHelper.func_76128_c((double)vres2.zCoord));
            while (player.field_70170_p.func_175623_d(t2) && t2.func_177956_o() > 0) {
                t2 = t2.func_177977_b();
            }
            this.clearTaintedBlock(player.field_70170_p, t1);
            this.clearTaintedBlock(player.field_70170_p, t2);
        }
    }

    public static double randomDouble() {
        return field_77697_d.nextDouble() - field_77697_d.nextDouble();
    }

    private void clearTaintedBlock(World world, BlockPos p) {
        Block bt = world.func_180495_p(p).func_177230_c();
        if (bt instanceof ITaintBlock) {
            ((ITaintBlock)bt).die(world, p, world.func_180495_p(p));
        }
    }

    public void onPlayerBaubleRender(ItemStack itemStack, EntityPlayer player, IRenderBauble.RenderType renderType, float v) {
        float rotateAngleY = ((float)player.field_70173_aa + v) / 5.0f;
        if (renderType == IRenderBauble.RenderType.BODY) {
            GlStateManager.func_179094_E();
            IModelCustom model = this.diceModels.computeIfAbsent(itemStack, key -> AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("renaissance_core", "textures/models/dice/dice12.obj")));
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("renaissance_core", "textures/models/dice/1221.png"));
            GlStateManager.func_179139_a((double)0.25, (double)0.25, (double)0.25);
            GlStateManager.func_179137_b((double)0.0, (double)(-4.0 + Math.sin((float)player.field_70173_aa / 10.0f) / 2.0), (double)0.0);
            GlStateManager.func_179114_b((float)(rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            model.renderAll();
            GlStateManager.func_179121_F();
        }
    }
}

