/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.capability;

import com.keletu.renaissance_core.capability.ICapConcilium;
import com.keletu.renaissance_core.capability.RCCapabilities;
import com.keletu.renaissance_core.events.EventHandlerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.FakePlayer;

public class CapThaumicConcilium
implements ICapConcilium {
    public static final ResourceLocation CHAINED_TIME = new ResourceLocation("renaissance_core", "chained_time");
    public static final ResourceLocation ETHEREAL = new ResourceLocation("renaissance_core", "ethereal");
    public static final ResourceLocation PONTIFEX_TOGGLE = new ResourceLocation("renaissance_core", "pontifex_toggle");
    public EntityPlayer player;
    public boolean lithographed;
    public boolean relieved;
    private boolean pontifexRobeToggle;
    public String[] monitored;
    private int chainedTime;
    private boolean ethereal;
    public int fleshAmount;

    public CapThaumicConcilium(EntityPlayer player) {
        if (!(player instanceof FakePlayer)) {
            this.player = player;
        } else {
            player = null;
        }
        this.lithographed = false;
        this.relieved = false;
        this.chainedTime = 0;
        this.ethereal = false;
        this.fleshAmount = 0;
        this.pontifexRobeToggle = false;
        this.monitored = new String[4];
    }

    @Override
    public int getChainedTime() {
        return this.chainedTime;
    }

    @Override
    public void setChainedTime(int time) {
        if (time != this.chainedTime) {
            this.updateStat(CHAINED_TIME, this.chainedTime);
        }
        this.chainedTime = time;
    }

    @Override
    public boolean isEthereal() {
        return this.ethereal;
    }

    @Override
    public void setEthereal(boolean ethereal) {
        if (ethereal != this.ethereal) {
            this.updateStat(ETHEREAL, ethereal);
        }
        this.ethereal = ethereal;
    }

    @Override
    public boolean getPontifexRobeToggle() {
        return this.ethereal;
    }

    @Override
    public void setPontifexRobeToggle(boolean toggle) {
        if (toggle != this.pontifexRobeToggle) {
            this.updateStat(PONTIFEX_TOGGLE, this.pontifexRobeToggle);
        }
        this.pontifexRobeToggle = toggle;
    }

    @Override
    public void setLocationCorrect() {
        this.updateStat(CHAINED_TIME, this.chainedTime);
        this.updateStat(ETHEREAL, this.ethereal);
        this.updateStat(PONTIFEX_TOGGLE, this.pontifexRobeToggle);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound properties = new NBTTagCompound();
        for (int i = 0; i < 4; ++i) {
            if (this.monitored[i] != null && !this.monitored[i].isEmpty()) {
                properties.func_74778_a("monitored" + i, this.monitored[i]);
                continue;
            }
            properties.func_74778_a("monitored" + i, "!!!NOTHING!!!");
        }
        properties.func_74757_a("lithographed", this.lithographed);
        properties.func_74757_a("relieved", this.relieved);
        properties.func_74768_a("chainedTime", this.chainedTime);
        properties.func_74757_a("ethereal", this.ethereal);
        properties.func_74757_a("pontifexRobeToggle", this.pontifexRobeToggle);
        properties.func_74768_a("fleshAmount", this.fleshAmount);
        return properties;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        for (int i = 0; i < 4; ++i) {
            this.monitored[i] = compound.func_74779_i("monitored" + i);
        }
        this.lithographed = compound.func_74767_n("lithographed");
        this.relieved = compound.func_74767_n("relieved");
        this.chainedTime = compound.func_74762_e("chainedTime");
        this.ethereal = compound.func_74767_n("ethereal");
        this.pontifexRobeToggle = compound.func_74767_n("pontifexRobeToggle");
        this.fleshAmount = compound.func_74762_e("fleshAmount");
    }

    private void updateStat(ResourceLocation stat, boolean value) {
        if (this.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)this.player;
            player.func_71064_a(new StatBase(stat.func_110624_b(), (ITextComponent)new TextComponentString(stat.func_110623_a())), value ? 1 : 0);
        }
    }

    private void updateStat(ResourceLocation stat, int value) {
        if (this.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)this.player;
            player.func_71064_a(new StatBase(stat.func_110624_b(), (ITextComponent)new TextComponentString(stat.func_110623_a())), value);
        }
    }

    @Override
    public void init(Entity entity, World world) {
        this.player = !(this.player instanceof FakePlayer) ? this.player : null;
    }

    @Override
    public void sync() {
        if (this.player == null) {
            return;
        }
        EventHandlerEntity.syncToClientConcilium(this.player);
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        private final CapThaumicConcilium counter;

        public Provider(EntityPlayer player) {
            this.counter = new CapThaumicConcilium(player);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == RCCapabilities.CONCILIUM;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(capability == RCCapabilities.CONCILIUM ? this.counter : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)RCCapabilities.CONCILIUM.getStorage().writeNBT(RCCapabilities.CONCILIUM, (Object)this.counter, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            RCCapabilities.CONCILIUM.getStorage().readNBT(RCCapabilities.CONCILIUM, (Object)this.counter, null, (NBTBase)nbt);
        }
    }
}

