/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.client.render;

import com.keletu.renaissance_core.client.render.ShaderCallback;
import com.keletu.renaissance_core.client.render.ShaderHelper;
import com.keletu.renaissance_core.entity.EntityQuicksilverElemental;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class RenderQuicksilverElemental
extends RenderBiped {
    private static final ResourceLocation SHADOW_TEXTURES = new ResourceLocation("textures/misc/shadow.png");
    private final ResourceLocation texture;
    private final ShaderCallback shaderCallback;

    public RenderQuicksilverElemental(ModelBiped model, ResourceLocation texture, float shadowSize) {
        super(Minecraft.func_71410_x().func_175598_ae(), model, shadowSize);
        this.texture = texture;
        this.shaderCallback = new ShaderCallback(){

            @Override
            public void call(int shader) {
            }
        };
    }

    public void func_76975_c(Entity entityIn, double x, double y, double z, float shadowAlpha, float partialTicks) {
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.field_76990_c.field_78724_e.func_110577_a(SHADOW_TEXTURES);
        World world = this.func_76982_b();
        GlStateManager.func_179132_a((boolean)false);
        float f = ((EntityQuicksilverElemental)entityIn).func_110143_aJ() / 30.0f;
        if (entityIn instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entityIn;
            f *= entityliving.func_70603_bj();
            if (entityliving.func_70631_g_()) {
                f *= 0.5f;
            }
        }
        double d5 = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        double d0 = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        double d1 = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        int i = MathHelper.func_76128_c((double)(d5 - (double)f));
        int j = MathHelper.func_76128_c((double)(d5 + (double)f));
        int k = MathHelper.func_76128_c((double)(d0 - (double)f));
        int l = MathHelper.func_76128_c((double)d0);
        int i1 = MathHelper.func_76128_c((double)(d1 - (double)f));
        int j1 = MathHelper.func_76128_c((double)(d1 + (double)f));
        double d2 = x - d5;
        double d3 = y - d0;
        double d4 = z - d1;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)new BlockPos(i, k, i1), (BlockPos)new BlockPos(j, l, j1))) {
            IBlockState iblockstate = world.func_180495_p(blockpos.func_177977_b());
            if (iblockstate.func_185901_i() == EnumBlockRenderType.INVISIBLE || world.func_175671_l(blockpos) <= 3) continue;
            this.func_188299_a(iblockstate, x, y, z, blockpos, shadowAlpha, f, d2, d3, d4);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
    }

    protected void func_77041_b(EntityLivingBase e, float p_77041_2_) {
        float s = e.func_110143_aJ() / 30.0f;
        GL11.glScalef((float)s, (float)s, (float)s);
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float pitch) {
        super.func_76986_a((EntityLiving)entity, x, y, z, yaw, pitch);
    }

    protected void func_77036_a(EntityLivingBase p_77036_1_, float p_77036_2_, float p_77036_3_, float p_77036_4_, float p_77036_5_, float p_77036_6_, float p_77036_7_) {
        ShaderHelper.useShader(ShaderHelper.wiggleShader, this.shaderCallback);
        super.func_77036_a(p_77036_1_, p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_);
        ShaderHelper.releaseShader();
    }

    protected ResourceLocation func_110775_a(EntityLiving entity) {
        return this.texture;
    }
}

