/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.entity;

import com.google.common.base.Optional;
import com.keletu.renaissance_core.RenaissanceCore;
import com.keletu.renaissance_core.entity.EntityCrimsonPontifex;
import com.keletu.renaissance_core.entity.EntityThaumGib;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.capabilities.IPlayerWarp;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.codechicken.lib.vec.Vector3;
import thaumcraft.common.lib.potions.PotionWarpWard;

public class EntityConcentratedWarpCharge
extends Entity
implements IEntityOwnable,
IEntityAdditionalSpawnData {
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityConcentratedWarpCharge.class, (DataSerializer)DataSerializers.field_187203_m);
    public int power;
    public int range;
    public boolean massHysteria = false;
    public boolean selfFlagellation = false;
    public boolean byForce = false;

    public EntityConcentratedWarpCharge(World p_i1762_1_) {
        super(p_i1762_1_);
        this.func_70105_a(1.0f, 1.0f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        return p_70112_1_ < 4096.0;
    }

    public EntityConcentratedWarpCharge(double p_i1763_2_, double p_i1763_4_, double p_i1763_6_, EntityPlayer p) {
        super(p.field_70170_p);
        this.func_70107_b(p_i1763_2_, p_i1763_4_, p_i1763_6_);
        this.power = 5;
        this.range = 1;
        this.byForce = true;
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        this.field_70159_w *= 0.7;
        this.field_70181_x *= 0.7;
        this.field_70179_y *= 0.7;
        float maxDist = this.byForce ? 9.0f : 49.0f;
        super.func_70071_h_();
        if (!(this.byForce || this.field_70173_aa % 120 != 0 && this.field_70173_aa != 0)) {
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), new SoundEvent(new ResourceLocation("renaissance_core:whispers")), SoundCategory.HOSTILE, 0.1f, 1.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70902_q() == null) {
                this.func_70106_y();
            }
            if (this.byForce && this.field_70173_aa > 200) {
                this.func_70106_y();
            }
            if (this.getOwnerEntity() != null) {
                Collection potions;
                EntityPlayer owner = (EntityPlayer)this.getOwnerEntity();
                if (owner.field_70128_L || this.field_71093_bK != owner.field_71093_bK) {
                    this.func_70106_y();
                }
                if (this.func_70068_e((Entity)owner) > 225.0) {
                    this.func_70107_b(owner.field_70165_t, owner.field_70163_u, owner.field_70161_v);
                }
                if (this.func_70068_e((Entity)owner) > (double)maxDist) {
                    EntityThaumGib.setEntityMotionFromVector(this, new Vector3(owner.field_70165_t, owner.field_70163_u, owner.field_70161_v), 1.0f);
                }
                if (!owner.field_71075_bZ.field_75100_b) {
                    this.field_70181_x -= 0.1;
                }
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                if (this.massHysteria && this.field_70173_aa % 10 == 0 && !(potions = owner.func_70651_bq()).isEmpty()) {
                    for (Object potion : potions) {
                        Potion id = potion.func_188419_a();
                        if (!id.func_76398_f()) continue;
                        int d = 5 + 4 * this.range;
                        List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72321_a((double)d, (double)d, (double)d).func_72321_a((double)(-d), (double)(-d), (double)(-d)));
                        entities.remove(owner);
                        Collections.shuffle(entities);
                        if (entities.isEmpty()) continue;
                        ((EntityLivingBase)entities.get(0)).func_70690_d((PotionEffect)potion);
                        owner.func_184589_d(id);
                        break;
                    }
                }
                if (this.selfFlagellation && this.field_70173_aa % 10 == 0) {
                    int d = 5 + 4 * this.range;
                    List entities = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72321_a((double)d, (double)d, (double)d).func_72321_a((double)(-d), (double)(-d), (double)(-d)));
                    entities.remove(owner);
                    if (!entities.isEmpty()) {
                        block1: for (EntityPlayer p : entities) {
                            Collection potions2 = owner.func_70651_bq();
                            if (potions2.isEmpty()) continue;
                            for (PotionEffect potion : potions2) {
                                Potion id = potion.func_188419_a();
                                if (!id.func_76398_f()) continue;
                                owner.func_70690_d(potion);
                                p.func_184589_d(id);
                                continue block1;
                            }
                        }
                    }
                }
                int warp = ThaumcraftCapabilities.getWarp((EntityPlayer)owner).get(IPlayerWarp.EnumWarpType.PERMANENT);
                int twarp = ThaumcraftCapabilities.getWarp((EntityPlayer)owner).get(IPlayerWarp.EnumWarpType.TEMPORARY);
                if (twarp == 0 && !this.byForce) {
                    this.func_70106_y();
                    return;
                }
                if (!owner.func_70644_a(PotionWarpWard.instance)) {
                    List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ());
                    if (!this.byForce) {
                        entities.remove(owner);
                    }
                    for (EntityLivingBase entity : entities) {
                        if (entity instanceof EntityCrimsonPontifex) continue;
                        entity.func_70097_a(EntityDamageSourceIndirect.func_76354_b((Entity)this, (Entity)owner), (float)warp / 10.0f * (float)this.power);
                        if (this.byForce) continue;
                        ThaumcraftApi.internalMethods.addWarpToPlayer(owner, -1, IPlayerWarp.EnumWarpType.TEMPORARY);
                    }
                }
            }
        }
        if (this.field_70170_p.field_72995_K && this.func_70902_q() != null) {
            if (this.field_70173_aa % 3 == 0) {
                RenaissanceCore.proxy.warpchain((EntityPlayer)this.func_70902_q(), this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
            }
            if (this.massHysteria && this.field_70170_p.field_73012_v.nextInt() % 8 == 0) {
                for (int i = 0; i < 10; ++i) {
                    RenaissanceCore.proxy.taintsplosion(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
            }
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        if (this.func_184753_b() == null) {
            nbttagcompound.func_186854_a("Owner", UUID.fromString(""));
        } else {
            nbttagcompound.func_186854_a("Owner", this.func_184753_b());
        }
        nbttagcompound.func_74768_a("power", this.power);
        nbttagcompound.func_74768_a("range", this.range);
        nbttagcompound.func_74757_a("massHysteria", this.massHysteria);
        nbttagcompound.func_74757_a("selfFlagellation", this.selfFlagellation);
        nbttagcompound.func_74757_a("byForce", this.byForce);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        UUID s = nbttagcompound.func_186857_a("Owner");
        if (s != null) {
            this.setOwner(s);
        }
        this.power = nbttagcompound.func_74762_e("power");
        this.range = nbttagcompound.func_74762_e("range");
        this.massHysteria = nbttagcompound.func_74767_n("massHysteria");
        this.selfFlagellation = nbttagcompound.func_74767_n("selfFlagellation");
        this.byForce = nbttagcompound.func_74767_n("byForce");
    }

    public boolean func_70067_L() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.0f;
    }

    public float func_70013_c() {
        return super.func_70013_c();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return super.func_70070_b();
    }

    public boolean func_70075_an() {
        return false;
    }

    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwner(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)p_184754_1_));
    }

    public Entity func_70902_q() {
        return this.getOwnerEntity();
    }

    public EntityLivingBase getOwnerEntity() {
        return this.field_70170_p.func_152378_a(this.func_184753_b());
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.massHysteria) {
            buffer.writeInt(1);
        } else if (this.selfFlagellation) {
            buffer.writeInt(2);
        } else if (this.byForce) {
            buffer.writeInt(3);
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        try {
            int val = additionalData.readInt();
            if (val == 1) {
                this.massHysteria = true;
            }
            if (val == 2) {
                this.selfFlagellation = true;
            }
            if (val == 3) {
                this.byForce = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

