/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.entity;

import com.keletu.renaissance_core.entity.AIAttackOnCollide;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.entities.ITaintedMob;
import thaumcraft.api.potions.PotionFluxTaint;

public class EntityTaintSheep
extends EntityMob
implements IShearable,
ITaintedMob {
    private static final DataParameter<Byte> DYE_COLOR = EntityDataManager.func_187226_a(EntityTaintSheep.class, (DataSerializer)DataSerializers.field_187191_a);
    private final InventoryCrafting inventoryCrafting = new InventoryCrafting(new Container(){

        public boolean func_75145_c(EntityPlayer playerIn) {
            return false;
        }
    }, 2, 1);
    private int sheepTimer;
    private EntityAIEatGrass entityAIEatGrass;

    public boolean func_70686_a(Class clazz) {
        return !ITaintedMob.class.isAssignableFrom(clazz);
    }

    public boolean func_184191_r(Entity otherEntity) {
        return otherEntity instanceof ITaintedMob || super.func_184191_r(otherEntity);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected Item func_146068_u() {
        return ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FLUX).func_77973_b();
    }

    protected void func_70628_a(boolean flag, int i) {
        if (this.field_70170_p.field_73012_v.nextInt(3) == 0) {
            if (this.field_70170_p.field_73012_v.nextBoolean()) {
                this.func_70099_a(ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FLUX), this.field_70131_O / 2.0f);
            } else {
                this.func_70099_a(ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FLUX), this.field_70131_O / 2.0f);
            }
        }
    }

    public int func_70658_aO() {
        return 1;
    }

    protected float func_70647_i() {
        return 0.7f;
    }

    public boolean func_70652_k(Entity victim) {
        if (super.func_70652_k(victim)) {
            if (victim instanceof EntityLivingBase) {
                int b0 = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    b0 = 3;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    b0 = 6;
                }
                if (b0 > 0 && this.field_70146_Z.nextInt(b0 + 1) > 2) {
                    ((EntityLivingBase)victim).func_70690_d(new PotionEffect(PotionFluxTaint.instance, b0 * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public EntityTaintSheep(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 1.3f);
        this.inventoryCrafting.func_70299_a(0, new ItemStack(Items.field_151100_aR));
        this.inventoryCrafting.func_70299_a(1, new ItemStack(Items.field_151100_aR));
    }

    protected void func_184651_r() {
        this.entityAIEatGrass = new EntityAIEatGrass((EntityLiving)this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.entityAIEatGrass);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIAttackOnCollide((EntityCreature)this, EntityVillager.class, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
    }

    protected void func_70619_bc() {
        this.sheepTimer = this.entityAIEatGrass.func_151499_f();
        super.func_70619_bc();
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        super.func_70636_d();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DYE_COLOR, (Object)0);
    }

    public void func_70103_a(byte id) {
        if (id == 10) {
            this.sheepTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return !this.getSheared();
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        this.setSheared(true);
        int i = 1 + this.field_70146_Z.nextInt(3);
        for (int j = 0; j < i; ++j) {
            ret.add(new ItemStack(Blocks.field_150325_L, 1, 10));
        }
        return ret;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Sheared", this.getSheared());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSheared(compound.func_74767_n("Sheared"));
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187757_eG;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187761_eI;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187759_eH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }

    public boolean getSheared() {
        return ((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0x10) != 0;
    }

    public void setSheared(boolean sheared) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        if (sheared) {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 | 0x10)));
        } else {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        if (this.sheepTimer <= 0) {
            return 0.0f;
        }
        if (this.sheepTimer >= 4 && this.sheepTimer <= 36) {
            return 1.0f;
        }
        return this.sheepTimer < 4 ? ((float)this.sheepTimer - p_70894_1_) / 4.0f : -((float)(this.sheepTimer - 40) - p_70894_1_) / 4.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float f = ((float)(this.sheepTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.2199115f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public void func_70615_aA() {
        this.setSheared(false);
    }

    public float func_70047_e() {
        return 0.95f * this.field_70131_O;
    }
}

