/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.events;

import baubles.api.BaublesApi;
import com.keletu.renaissance_core.ConfigsRC;
import com.keletu.renaissance_core.items.RCItems;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.ThaumcraftMaterials;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.capabilities.IPlayerWarp;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.damagesource.DamageSourceThaumcraft;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.entities.monster.EntityPech;
import thaumcraft.common.items.consumables.ItemSanitySoap;
import thaumcraft.common.lib.potions.PotionWarpWard;

@Mod.EventBusSubscriber(modid="renaissance_core")
public class CursedEvents {
    static Random rand = new Random();
    private static EntityPlayer cursedPlayer;
    public static final Map<EntityPlayer, AxisAlignedBB> CURSED_AURA;

    public static boolean hasThaumiumCursed(EntityPlayer player) {
        return BaublesApi.isBaubleEquipped((EntityPlayer)player, (Item)RCItems.dice12) != -1;
    }

    public static AxisAlignedBB getBoundingBoxAroundEntity(Entity entity, double radius) {
        return new AxisAlignedBB(entity.field_70165_t - radius, entity.field_70163_u - radius, entity.field_70161_v - radius, entity.field_70165_t + radius, entity.field_70163_u + radius, entity.field_70161_v + radius);
    }

    public static boolean isVanillaMaterial(EntityPlayer player) {
        Item itemTool = player.func_184614_ca().func_77973_b();
        if (itemTool instanceof ItemTool) {
            return ((ItemTool)itemTool).field_77862_b.equals((Object)Item.ToolMaterial.DIAMOND) || ((ItemTool)itemTool).field_77862_b.equals((Object)Item.ToolMaterial.IRON) || ((ItemTool)itemTool).field_77862_b.equals((Object)Item.ToolMaterial.STONE) || ((ItemTool)itemTool).field_77862_b.equals((Object)Item.ToolMaterial.GOLD) || ((ItemTool)itemTool).field_77862_b.equals((Object)Item.ToolMaterial.WOOD);
        }
        if (itemTool instanceof ItemSword) {
            return ((ItemSword)itemTool).field_150933_b.equals((Object)Item.ToolMaterial.DIAMOND) || ((ItemSword)itemTool).field_150933_b.equals((Object)Item.ToolMaterial.IRON) || ((ItemSword)itemTool).field_150933_b.equals((Object)Item.ToolMaterial.STONE) || ((ItemSword)itemTool).field_150933_b.equals((Object)Item.ToolMaterial.GOLD) || ((ItemSword)itemTool).field_150933_b.equals((Object)Item.ToolMaterial.WOOD);
        }
        return false;
    }

    public static boolean isMaterialThaumium(EntityPlayer player) {
        Item itemTool = player.func_184614_ca().func_77973_b();
        if (itemTool instanceof ItemTool) {
            return ((ItemTool)itemTool).field_77862_b.equals((Object)ThaumcraftMaterials.TOOLMAT_ELEMENTAL) || ((ItemTool)itemTool).field_77862_b.equals((Object)ThaumcraftMaterials.TOOLMAT_VOID) || ((ItemTool)itemTool).field_77862_b.equals((Object)ThaumcraftMaterials.TOOLMAT_THAUMIUM);
        }
        if (itemTool instanceof ItemSword) {
            return ((ItemSword)itemTool).field_150933_b.equals((Object)ThaumcraftMaterials.TOOLMAT_ELEMENTAL) || ((ItemSword)itemTool).field_150933_b.equals((Object)ThaumcraftMaterials.TOOLMAT_VOID) || ((ItemSword)itemTool).field_150933_b.equals((Object)ThaumcraftMaterials.TOOLMAT_THAUMIUM);
        }
        return false;
    }

    public static void addDrop(LivingDropsEvent event, ItemStack drop) {
        if (drop == null || drop.func_77973_b() == null) {
            return;
        }
        EntityItem entityitem = new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, drop);
        entityitem.func_174867_a(10);
        event.getDrops().add(entityitem);
    }

    public static void addDropWithChance(LivingDropsEvent event, ItemStack drop, int chance) {
        if (new Random().nextInt(100) < chance) {
            CursedEvents.addDrop(event, drop);
        }
    }

    public static ItemStack getRandomSizeStack(Item item, int minAmount, int maxAmount) {
        return new ItemStack(item, minAmount + new Random().nextInt(maxAmount - minAmount + 1));
    }

    public static ItemStack getRandomSizeStack(Item item, int minAmount, int maxAmount, int meta) {
        return new ItemStack(item, minAmount + new Random().nextInt(maxAmount - minAmount + 1), meta);
    }

    public static void addOneOf(LivingDropsEvent event, ItemStack ... itemStacks) {
        int chosenStack = new Random().nextInt(itemStacks.length);
        CursedEvents.addDrop(event, itemStacks[chosenStack]);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDrops(LivingDropsEvent event) {
        if (event.isRecentlyHit() && event.getSource() != null && event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityLivingBase killed = event.getEntityLiving();
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            if (CursedEvents.hasThaumiumCursed(player)) {
                if (killed.getClass() == EntityZombie.class || killed.getClass() == EntityHusk.class) {
                    CursedEvents.addDropWithChance(event, CursedEvents.getRandomSizeStack(Items.field_191525_da, 1, 18), 35);
                } else if (killed.getClass() == EntitySkeleton.class || killed.getClass() == EntityStray.class) {
                    CursedEvents.addDropWithChance(event, ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.ENTROPY, (int)(rand.nextInt(10) + 1)), 20);
                } else if (killed.getClass() == EntitySpider.class || killed.getClass() == EntityCaveSpider.class) {
                    CursedEvents.addDropWithChance(event, CursedEvents.getRandomSizeStack(ItemsTC.nuggets, 1, 18, 5), 10);
                } else if (killed.getClass() == EntityCreeper.class) {
                    CursedEvents.addDropWithChance(event, ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.EARTH, (int)(rand.nextInt(10) + 1)), 20);
                } else if (killed.getClass() == EntityWitch.class && ThaumcraftCapabilities.knowsResearch((EntityPlayer)player, (String[])new String[]{"FIRSTSTEPS"})) {
                    CursedEvents.addDropWithChance(event, CursedEvents.getRandomSizeStack(ItemsTC.salisMundus, 2, 3), 30);
                } else if (killed.getClass() == EntityPigZombie.class) {
                    CursedEvents.addDropWithChance(event, CursedEvents.getRandomSizeStack(ItemsTC.tallow, 1, 5), 50);
                } else if (killed.getClass() == EntitySilverfish.class) {
                    CursedEvents.addDropWithChance(event, CursedEvents.getRandomSizeStack(ItemsTC.amber, 1, 2), 30);
                } else if (killed.getClass() == EntityEnderman.class && ThaumcraftCapabilities.knowsResearch((EntityPlayer)player, (String[])new String[]{"BASEELDRITCH"})) {
                    CursedEvents.addDropWithChance(event, new ItemStack(ItemsTC.voidSeed), 5);
                } else if (killed.getClass() == EntityBlaze.class || killed.getClass() == EntityMagmaCube.class) {
                    CursedEvents.addDropWithChance(event, ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FIRE, (int)(rand.nextInt(10) + 1)), 20);
                } else if (killed.getClass() == EntityGhast.class) {
                    CursedEvents.addDropWithChance(event, CursedEvents.getRandomSizeStack(ItemsTC.quicksilver, 1, 4), 50);
                } else if (killed.getClass() == EntitySlime.class) {
                    CursedEvents.addDropWithChance(event, ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.WATER, (int)(rand.nextInt(10) + 1)), 20);
                } else if (killed.getClass() == EntityPig.class) {
                    CursedEvents.addDrop(event, CursedEvents.getRandomSizeStack(ItemsTC.chunks, 1, 10, 2));
                } else if (killed.getClass() == EntityCow.class) {
                    CursedEvents.addDrop(event, CursedEvents.getRandomSizeStack(ItemsTC.chunks, 1, 10, 0));
                } else if (killed.getClass() == EntityChicken.class) {
                    CursedEvents.addDrop(event, CursedEvents.getRandomSizeStack(ItemsTC.chunks, 1, 10, 1));
                } else if (killed.getClass() == EntityRabbit.class) {
                    CursedEvents.addDrop(event, CursedEvents.getRandomSizeStack(ItemsTC.chunks, 1, 10, 4));
                } else if (killed.getClass() == EntitySheep.class) {
                    CursedEvents.addDrop(event, CursedEvents.getRandomSizeStack(ItemsTC.chunks, 1, 10, 5));
                } else if (killed.getClass() == EntityVillager.class) {
                    CursedEvents.addDrop(event, CursedEvents.getRandomSizeStack(ItemsTC.chunks, 1, 2));
                } else if (killed.getClass() == EntityPech.class) {
                    CursedEvents.addDropWithChance(event, new ItemStack(RCItems.pech_backpack), 50);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerWakeUpEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (CursedEvents.hasThaumiumCursed(player)) {
            if (rand.nextInt(2) == 0) {
                AuraHelper.polluteAura((World)player.field_70170_p, (BlockPos)player.func_180425_c(), (float)ConfigsRC.cursedSleepPollution, (boolean)true);
            } else {
                ThaumcraftApi.internalMethods.addWarpToPlayer(player, ConfigsRC.cursedSleepWarpPoint, IPlayerWarp.EnumWarpType.TEMPORARY);
            }
        }
    }

    @SubscribeEvent
    public static void tickHandler(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = event.player;
        if (CursedEvents.hasThaumiumCursed(player)) {
            CURSED_AURA.put(player, CursedEvents.getBoundingBoxAroundEntity((Entity)player, 128.0));
        } else {
            CURSED_AURA.remove(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void miningBlocks(PlayerEvent.BreakSpeed event) {
        float correctedSpeed = event.getOriginalSpeed();
        float miningBoost = 1.0f;
        if (CursedEvents.hasThaumiumCursed(event.getEntityPlayer())) {
            if (CursedEvents.isVanillaMaterial(event.getEntityPlayer())) {
                miningBoost -= 0.5f;
            }
            if (CursedEvents.isMaterialThaumium(event.getEntityPlayer())) {
                miningBoost += 0.25f;
            }
        }
        correctedSpeed *= miningBoost;
        event.setNewSpeed(event.getNewSpeed() + (correctedSpeed -= event.getOriginalSpeed()));
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        EntityPlayer player;
        if (event.getAmount() >= Float.MAX_VALUE) {
            return;
        }
        if (event.getSource().func_76346_g() instanceof EntityPlayer && CursedEvents.hasThaumiumCursed(player = (EntityPlayer)event.getSource().func_76346_g())) {
            if (CursedEvents.isVanillaMaterial(player)) {
                event.setAmount(event.getAmount() / 2.0f);
            }
            if (CursedEvents.isMaterialThaumium(player)) {
                event.setAmount(event.getAmount() * 1.25f);
            }
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            player = (EntityPlayer)event.getEntityLiving();
            if (event.getSource() == DamageSourceThaumcraft.taint && CursedEvents.hasThaumiumCursed(player)) {
                event.setAmount(event.getAmount() * 2.0f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingHeal(LivingHealEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && CursedEvents.hasThaumiumCursed(player = (EntityPlayer)event.getEntityLiving())) {
            if ((double)(AuraHelper.getVis((World)player.field_70170_p, (BlockPos)player.func_180425_c()) / (float)AuraHelper.getAuraBase((World)player.field_70170_p, (BlockPos)player.func_180425_c())) <= ConfigsRC.cursedPlayerRegenHealthAura) {
                event.setAmount(0.0f);
            } else {
                AuraHelper.drainVis((World)player.field_70170_p, (BlockPos)player.func_180425_c(), (float)(event.getAmount() * ConfigsRC.cursedPlayerRegenHealthVis), (boolean)false);
            }
        }
    }

    @SubscribeEvent
    public static void onEatFoods(LivingEntityUseItemEvent.Finish event) {
        if (event.getEntityLiving() instanceof EntityPlayer && !event.getEntity().field_70170_p.field_72995_K) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemStack food = event.getItem();
            if (CursedEvents.hasThaumiumCursed(player)) {
                if (OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"listAllHarmfulFoods"), (ItemStack[])new ItemStack[]{food})) {
                    ThaumcraftApi.internalMethods.addWarpToPlayer(player, 3, IPlayerWarp.EnumWarpType.TEMPORARY);
                    player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 300, 0));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 0));
                } else if (OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)"listAllRawMeats"), (ItemStack[])new ItemStack[]{food})) {
                    ThaumcraftApi.internalMethods.addWarpToPlayer(player, 1, IPlayerWarp.EnumWarpType.TEMPORARY);
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 150, 0));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onUseSoap(LivingEntityUseItemEvent.Stop event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (player.field_70170_p.field_72995_K) {
                return;
            }
            int qq = event.getItem().func_77988_m() - event.getDuration();
            if (CursedEvents.hasThaumiumCursed(player) && qq > 95 && event.getItem().func_77973_b() instanceof ItemSanitySoap) {
                int k;
                int j;
                int i;
                IPlayerWarp warp = ThaumcraftCapabilities.getWarp((EntityPlayer)player);
                int amt = 1;
                if (player.func_70644_a(PotionWarpWard.instance)) {
                    ++amt;
                }
                if (player.field_70170_p.func_180495_p(new BlockPos(i = MathHelper.func_76128_c((double)player.field_70165_t), j = MathHelper.func_76128_c((double)player.field_70163_u), k = MathHelper.func_76128_c((double)player.field_70161_v))).func_177230_c() == BlocksTC.purifyingFluid) {
                    ++amt;
                }
                if (ConfigsRC.canRemovePermanentWarp) {
                    if (warp.get(IPlayerWarp.EnumWarpType.PERMANENT) > amt) {
                        ThaumcraftApi.internalMethods.addWarpToPlayer(player, -amt, IPlayerWarp.EnumWarpType.PERMANENT);
                    } else {
                        ThaumcraftApi.internalMethods.addWarpToPlayer(player, -warp.get(IPlayerWarp.EnumWarpType.PERMANENT), IPlayerWarp.EnumWarpType.PERMANENT);
                    }
                }
                if (warp.get(IPlayerWarp.EnumWarpType.NORMAL) > amt * 2) {
                    ThaumcraftApi.internalMethods.addWarpToPlayer(player, -amt * 2, IPlayerWarp.EnumWarpType.NORMAL);
                } else {
                    ThaumcraftApi.internalMethods.addWarpToPlayer(player, -warp.get(IPlayerWarp.EnumWarpType.NORMAL), IPlayerWarp.EnumWarpType.NORMAL);
                }
                if (warp.get(IPlayerWarp.EnumWarpType.TEMPORARY) > 0) {
                    ThaumcraftApi.internalMethods.addWarpToPlayer(player, -warp.get(IPlayerWarp.EnumWarpType.TEMPORARY), IPlayerWarp.EnumWarpType.TEMPORARY);
                }
                event.getItem().func_190918_g(1);
                event.setCanceled(true);
            }
        }
    }

    static {
        CURSED_AURA = new WeakHashMap<EntityPlayer, AxisAlignedBB>();
    }
}

