/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.events;

import baubles.common.network.PacketHandler;
import com.keletu.renaissance_core.RenaissanceCore;
import com.keletu.renaissance_core.blocks.RCBlocks;
import com.keletu.renaissance_core.blocks.TileDestabilizedCrystal;
import com.keletu.renaissance_core.blocks.TileQuicksilverCrucible;
import com.keletu.renaissance_core.entity.EntityTaintChicken;
import com.keletu.renaissance_core.entity.EntityTaintCow;
import com.keletu.renaissance_core.entity.EntityTaintCreeper;
import com.keletu.renaissance_core.entity.EntityTaintPig;
import com.keletu.renaissance_core.entity.EntityTaintRabbit;
import com.keletu.renaissance_core.entity.EntityTaintSheep;
import com.keletu.renaissance_core.entity.EntityTaintVillager;
import com.keletu.renaissance_core.events.CursedEvents;
import com.keletu.renaissance_core.items.ItemVisConductor;
import com.keletu.renaissance_core.items.RCItems;
import com.keletu.renaissance_core.packet.PacketFXLightning;
import com.keletu.renaissance_core.util.PolishRecipe;
import fr.wind_blade.isorropia.common.IsorropiaAPI;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectEventProxy;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.AspectRegistryEvent;
import thaumcraft.api.entities.ITaintedMob;
import thaumcraft.api.potions.PotionFluxTaint;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.entities.construct.EntityOwnedConstruct;
import thaumcraft.common.entities.monster.EntityPech;
import thaumcraft.common.entities.monster.EntityThaumicSlime;
import thaumcraft.common.entities.monster.tainted.EntityTaintCrawler;
import thaumcraft.common.golems.EntityThaumcraftGolem;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.tiles.crafting.TileInfusionMatrix;
import thaumcraft.common.tiles.crafting.TilePedestal;

@Mod.EventBusSubscriber
public class RegistryEvents {
    @SubscribeEvent
    public static void livingDeath(LivingDeathEvent event) {
        if (!(event.getEntityLiving().field_70170_p.field_72995_K || event.getEntityLiving() instanceof EntityOwnedConstruct || event.getEntityLiving() instanceof EntityGolem || event.getEntityLiving() instanceof ITaintedMob || !event.getEntityLiving().func_70644_a(PotionFluxTaint.instance))) {
            ITaintedMob entity = null;
            if (event.getEntityLiving() instanceof EntityCreeper) {
                entity = new EntityTaintCreeper(event.getEntityLiving().field_70170_p);
            } else if (event.getEntityLiving() instanceof EntitySheep) {
                entity = new EntityTaintSheep(event.getEntityLiving().field_70170_p);
            } else if (event.getEntityLiving() instanceof EntityCow) {
                entity = new EntityTaintCow(event.getEntityLiving().field_70170_p);
            } else if (event.getEntityLiving() instanceof EntityPig) {
                entity = new EntityTaintPig(event.getEntityLiving().field_70170_p);
            } else if (event.getEntityLiving() instanceof EntityChicken) {
                entity = new EntityTaintChicken(event.getEntityLiving().field_70170_p);
            } else if (event.getEntityLiving() instanceof EntityVillager) {
                entity = new EntityTaintVillager(event.getEntityLiving().field_70170_p);
            } else if (event.getEntityLiving().func_70668_bt() == EnumCreatureAttribute.ARTHROPOD || event.getEntityLiving() instanceof EntityAnimal) {
                int n = (int)Math.max(1.0, Math.sqrt(event.getEntityLiving().func_110138_aP() + 2.0f));
                for (int a = 0; a < n; ++a) {
                    EntityTaintCrawler e = new EntityTaintCrawler(event.getEntityLiving().field_70170_p);
                    e.func_70012_b(event.getEntityLiving().field_70165_t + (double)((event.getEntityLiving().field_70170_p.field_73012_v.nextFloat() - event.getEntityLiving().field_70170_p.field_73012_v.nextFloat()) * event.getEntityLiving().field_70130_N), event.getEntityLiving().field_70163_u + (double)(event.getEntityLiving().field_70170_p.field_73012_v.nextFloat() * event.getEntityLiving().field_70131_O), event.getEntityLiving().field_70161_v + (double)((event.getEntityLiving().field_70170_p.field_73012_v.nextFloat() - event.getEntityLiving().field_70170_p.field_73012_v.nextFloat()) * event.getEntityLiving().field_70130_N), (float)event.getEntityLiving().field_70170_p.field_73012_v.nextInt(360), 0.0f);
                    event.getEntityLiving().field_70170_p.func_72838_d((Entity)e);
                }
                event.getEntityLiving().func_70106_y();
                event.setCanceled(true);
            } else if (event.getEntityLiving() instanceof EntityRabbit) {
                entity = new EntityTaintRabbit(event.getEntityLiving().field_70170_p);
                ((EntityRabbit)entity).func_175529_r(((EntityRabbit)event.getEntityLiving()).func_175531_cl());
            } else {
                entity = new EntityThaumicSlime(event.getEntityLiving().field_70170_p);
                ((EntityThaumicSlime)entity).func_70799_a((int)(1.0f + Math.min(event.getEntityLiving().func_110138_aP() / 10.0f, 6.0f)), false);
            }
            if (entity != null) {
                entity.func_70012_b(event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, event.getEntityLiving().field_70177_z, 0.0f);
                event.getEntityLiving().field_70170_p.func_72838_d((Entity)entity);
                if (!(event.getEntityLiving() instanceof EntityPlayer)) {
                    event.getEntityLiving().func_70106_y();
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void regBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{RCBlocks.pechHead_normal});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{RCBlocks.pechHead_hunter});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{RCBlocks.pechHead_thaumaturge});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{RCBlocks.full_crucible});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{RCBlocks.quicksilver_crucible});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{RCBlocks.destabilized_crystal});
        GameRegistry.registerTileEntity(TileQuicksilverCrucible.class, (ResourceLocation)new ResourceLocation("renaissance_core", "quicksilver_crucible"));
        GameRegistry.registerTileEntity(TileDestabilizedCrystal.class, (ResourceLocation)new ResourceLocation("renaissance_core", "destabilized_crystal"));
    }

    @SubscribeEvent
    public static void regItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.arcane_lime_powder});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.dice12});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.pech_backpack});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.elixir});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.pontifex_hood});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.pontifex_robe});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.pontifex_legs});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.pontifex_boots});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.molot});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.crimson_annales});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.research_notes_crimson});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.runic_chestplate});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.runic_leggings});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.bottle_of_thick_taint});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.research_page});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.vis_conductor});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.dump_jackboots});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.tight_belt});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.burdening_amulet});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.item_icon});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.pechHeadNormal});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.pechHeadHunter});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.pechHeadThaumaturge});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.quicksilverCrucible});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RCItems.destabilizedCrystal});
    }

    @SubscribeEvent
    public static void registerAspects(AspectRegistryEvent event) {
        AspectEventProxy proxy = event.register;
        proxy.registerComplexObjectTag(new ItemStack(RCItems.pechHeadNormal, 1, 0), new AspectList().add(Aspect.MAN, 20).add(Aspect.DESIRE, 20).add(Aspect.TOOL, 20));
        proxy.registerComplexObjectTag(new ItemStack(RCItems.pechHeadHunter, 1, 0), new AspectList().add(Aspect.MAN, 20).add(Aspect.DESIRE, 20).add(Aspect.AVERSION, 20));
        proxy.registerComplexObjectTag(new ItemStack(RCItems.pechHeadThaumaturge, 1, 0), new AspectList().add(Aspect.MAN, 20).add(Aspect.DESIRE, 20).add(Aspect.MAGIC, 20));
        proxy.registerComplexObjectTag(new ItemStack(RCItems.dice12, 1, 0), new AspectList().add(Aspect.AIR, 66).add(Aspect.WATER, 66).add(Aspect.FIRE, 66).add(Aspect.EARTH, 66).add(Aspect.ENTROPY, 66).add(Aspect.ORDER, 66));
        proxy.registerComplexObjectTag(new ItemStack(RCItems.crimson_annales, 1, 0), new AspectList().add(Aspect.MIND, 30).add(IsorropiaAPI.HUNGER, 30).add(Aspect.ELDRITCH, 30).add(Aspect.MAN, 30));
        proxy.registerComplexObjectTag(new ItemStack(RCItems.research_notes_crimson, 1, 0), new AspectList().add(Aspect.MIND, 66).add(Aspect.ELDRITCH, 66).add(IsorropiaAPI.WRATH, 66));
        proxy.registerComplexObjectTag(new ItemStack(RCItems.quicksilverCrucible, 1, 0), new AspectList().add(Aspect.METAL, 100).add(Aspect.MAGIC, 100).add(Aspect.FIRE, 30).add(IsorropiaAPI.FLESH, 10));
        proxy.registerComplexObjectTag(new ItemStack(RCItems.research_page, 1, 0), new AspectList().add(Aspect.MIND, 30));
        proxy.registerComplexObjectTag(new ItemStack(RCItems.research_page, 1, 1), new AspectList().add(Aspect.MIND, 30));
        proxy.registerComplexObjectTag(new ItemStack(RCItems.research_page, 1, 2), new AspectList().add(Aspect.MIND, 30));
        proxy.registerComplexObjectTag(new ItemStack(RCItems.research_page, 1, 3), new AspectList().add(Aspect.MIND, 30));
        proxy.registerComplexObjectTag(new ItemStack(RCItems.research_page, 1, 4), new AspectList().add(Aspect.MIND, 30));
    }

    @SubscribeEvent
    public static void onGolemInWall(LivingHurtEvent event) {
        EntityThaumcraftGolem golem;
        if (event.getEntity() instanceof EntityThaumcraftGolem && (golem = (EntityThaumcraftGolem)event.getEntity()).getProperties().hasTrait(RenaissanceCore.BUBBLE) && (Objects.equals(event.getSource().field_76373_n, DamageSource.field_76368_d.field_76373_n) || Objects.equals(event.getSource().field_76373_n, DamageSource.field_82729_p.field_76373_n))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        Random rand = new Random();
        if (event.getEntityLiving() instanceof EntityPech && event.isRecentlyHit() && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityPlayer && !(event.getSource().func_76346_g() instanceof FakePlayer) && event.getEntityLiving().getClass() == EntityPech.class && event.isRecentlyHit() && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityPlayer) {
            ItemStack weap;
            if (!CursedEvents.hasThaumiumCursed((EntityPlayer)event.getSource().func_76346_g())) {
                RegistryEvents.addDropWithChance(event, new ItemStack(RCItems.pech_backpack), 3);
            }
            if (!(weap = ((EntityPlayer)event.getSource().func_76346_g()).func_184586_b(EnumHand.MAIN_HAND)).func_190926_b() && weap.func_77973_b() == ForgeRegistries.ITEMS.getValue(new ResourceLocation("forbiddenmagicre", "skull_axe")) && rand.nextInt(26) <= 3 + EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)weap)) {
                if (((EntityPech)event.getEntityLiving()).getPechType() == 1) {
                    RegistryEvents.addDrop(event, new ItemStack(RCItems.pechHeadThaumaturge, 1, 0));
                } else if (((EntityPech)event.getEntityLiving()).getPechType() == 2) {
                    RegistryEvents.addDrop(event, new ItemStack(RCItems.pechHeadHunter, 1, 0));
                } else {
                    RegistryEvents.addDrop(event, new ItemStack(RCItems.pechHeadNormal, 1, 0));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onInfusion(PlayerEvent.ItemCraftedEvent event) {
        AspectList aspectList = PolishRecipe.getPolishmentRecipe(event.crafting);
        if (aspectList != null) {
            int z;
            int y;
            int x;
            BlockPos pos;
            ItemStack wand;
            NBTTagCompound fociTag;
            EntityPlayer player = event.player;
            double iX = event.player.field_70165_t;
            double iY = event.player.field_70163_u + 1.0;
            double iZ = event.player.field_70161_v;
            boolean found = false;
            for (int yy = -16; yy <= 16; ++yy) {
                for (int zz = -16; zz <= 16; ++zz) {
                    for (int xx = -16; xx <= 16; ++xx) {
                        if (!(event.player.field_70170_p.func_175625_s(new BlockPos((int)event.player.field_70165_t + xx, (int)event.player.field_70163_u + yy, (int)event.player.field_70161_v + zz)) instanceof TileInfusionMatrix)) continue;
                        iX = event.player.field_70165_t + (double)xx;
                        iY = event.player.field_70163_u + (double)yy;
                        iZ = event.player.field_70161_v + (double)zz;
                        found = true;
                    }
                }
            }
            if (player.func_184586_b(player.func_184600_cs()) != null && found && player.func_184586_b(player.func_184600_cs()).func_77973_b() instanceof ItemVisConductor && (fociTag = (wand = player.func_184586_b(player.func_184600_cs())).func_77978_p()) != null && fociTag.func_74764_b("blockX") && player.field_70170_p.func_175625_s(pos = new BlockPos(x = fociTag.func_74762_e("blockX"), y = fociTag.func_74762_e("blockY"), z = fociTag.func_74762_e("blockZ"))) instanceof TileDestabilizedCrystal) {
                TileDestabilizedCrystal crystal = (TileDestabilizedCrystal)player.field_70170_p.func_175625_s(pos);
                int amount = MathHelper.func_76125_a((int)(fociTag.func_74762_e("amount") - crystal.capacity), (int)0, (int)Integer.MAX_VALUE);
                if (amount >= aspectList.getAmount(aspectList.getAspects()[0]) && crystal.aspect.equalsIgnoreCase(aspectList.getAspects()[0].getTag())) {
                    if (!player.field_70170_p.field_72995_K) {
                        player.field_70170_p.func_175698_g(pos);
                        player.field_70170_p.func_175713_t(pos);
                        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundsTC.shock, SoundCategory.BLOCKS, 0.8f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
                        player.func_184597_cx();
                        int rgb = ((Aspect)Aspect.aspects.get(crystal.aspect)).getColor();
                        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXLightning((float)player.field_70165_t, (float)(player.field_70163_u + 1.0), (float)player.field_70161_v, (float)iX, (float)iY, (float)iZ, rgb, 1.0f), new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 32.0));
                        return;
                    }
                    FXDispatcher.INSTANCE.burst((double)x, (double)y, (double)z, 2.0f);
                }
            }
            if (!event.player.field_70170_p.field_72995_K) {
                event.crafting.func_190918_g(1);
                TileEntity te = event.player.field_70170_p.func_175625_s(new BlockPos(iX, iY - 2.0, iZ));
                if (te instanceof TilePedestal) {
                    ((TilePedestal)te).func_70299_a(0, ItemStack.field_190927_a);
                    player.func_184597_cx();
                }
            }
        }
    }

    public static void addDrop(LivingDropsEvent event, ItemStack drop) {
        EntityItem entityitem = new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, drop);
        event.getDrops().add(entityitem);
    }

    public static void addDropWithChance(LivingDropsEvent event, ItemStack drop, int chance) {
        if (new Random().nextInt(100) < chance) {
            RegistryEvents.addDrop(event, drop);
        }
    }
}

