/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.module.botania;

import com.keletu.renaissance_core.ConfigsRC;
import com.keletu.renaissance_core.module.botania.Tools;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.nbt.NBTTagCompound;
import vazkii.botania.common.block.subtile.generating.SubTileEndoflame;

public class SubTileEndoflameModified
extends SubTileEndoflame {
    private static final String TAG_FLOWER_NUM = "flowerNum";
    private static final int RANGE = 3;
    private int flowerNum = -1;
    private double efficiency = 1.0;
    private int passiveGeneration = 3;
    private int passiveDelay = 2;

    public void setEfficiency(double efficiency) {
        if (Math.abs(this.efficiency - efficiency) > 1.0E-4) {
            this.efficiency = efficiency;
            this.updatePassiveValue();
        }
    }

    private void updatePassiveValue() {
        double currentGenerate = 1.5 * this.efficiency;
        this.passiveDelay = Tools.getGenerationPeriod(currentGenerate);
        this.passiveGeneration = (int)((double)this.passiveDelay * currentGenerate);
        if (this.passiveGeneration == 0) {
            this.passiveGeneration = 1;
        }
    }

    public void onUpdate() {
        super.onUpdate();
        if (!(this.supertile.func_145831_w().field_72995_K || this.flowerNum >= 0 && this.ticksExisted % 80 != 0)) {
            this.flowerNum = Tools.getNearbyFlowers(this.getWorld(), this.getPos(), 5, ste -> ste instanceof SubTileEndoflame && ((SubTileEndoflame)ste).canGeneratePassively());
            this.setEfficiency(Tools.getOutputEfficiency(this.flowerNum, ConfigsRC.endoFlameMaxFlowers));
        }
    }

    public int getValueForPassiveGeneration() {
        return this.passiveGeneration;
    }

    public int getDelayBetweenPassiveGeneration() {
        return this.passiveDelay;
    }

    public void renderHUD(Minecraft mc, ScaledResolution res) {
        super.renderHUD(mc, res);
        Tools.renderTooManyFlowers(mc, res, this.flowerNum, ConfigsRC.endoFlameMaxFlowers);
    }

    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_FLOWER_NUM, this.flowerNum);
    }

    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        this.flowerNum = cmp.func_74762_e(TAG_FLOWER_NUM);
    }
}

