/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.module.botania;

import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vazkii.botania.api.subtile.SubTileEntity;
import vazkii.botania.common.block.tile.TileSpecialFlower;

public final class Tools {
    public static int getNearbyFlowers(World world, BlockPos blockPos, int range, Predicate<SubTileEntity> predicate) {
        int flowerNum = 0;
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)blockPos.func_177982_a(-range, -range, -range), (BlockPos)blockPos.func_177982_a(range + 1, range + 1, range + 1))) {
            SubTileEntity ste;
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof TileSpecialFlower) || !predicate.test(ste = ((TileSpecialFlower)te).getSubTile())) continue;
            ++flowerNum;
        }
        return flowerNum;
    }

    public static void renderTooManyFlowers(Minecraft mc, ScaledResolution res, int flowerNum, int max) {
        int color = 0xFF0000;
        if (flowerNum > max) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            String infoName = I18n.func_135052_a((String)"message.renaissance-core.botaniaaddon.manyflowers", (Object[])new Object[]{String.format("%.1f", Tools.getOutputEfficiency(flowerNum, max) * 100.0)});
            int width = 16 + mc.field_71466_p.func_78256_a(infoName) / 2;
            int x = res.func_78326_a() / 2 - width;
            int y = res.func_78328_b() / 2 + 30;
            mc.field_71466_p.func_175063_a(infoName, (float)(x + 20), (float)(y + 5), color);
            GlStateManager.func_179140_f();
            GlStateManager.func_179084_k();
        }
    }

    public static double getOutputEfficiency(int flowerNum, int max) {
        if (flowerNum <= max) {
            return 1.0;
        }
        return ((double)max + Math.log1p(flowerNum - max)) / (double)flowerNum;
    }

    public static int getGenerationPeriod(double generationPerTick) {
        double minError = generationPerTick * 2.0 % 1.0;
        int minIndex = 2;
        for (int i = 2; i < 20; ++i) {
            double errorOver = generationPerTick * (double)i % 1.0;
            double errorBelow = 1.0 - errorOver;
            if (errorOver < minError) {
                minError = errorOver;
                minIndex = i;
            }
            if (!(errorBelow < minError)) continue;
            minError = errorBelow;
            minIndex = i;
        }
        return minIndex;
    }
}

