/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.module.botania;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.items.resources.ItemCrystalEssence;
import vazkii.botania.api.internal.IGuiLexiconEntry;
import vazkii.botania.api.lexicon.ILexicon;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.lexicon.LexiconRecipeMappings;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.gui.lexicon.GuiLexiconEntry;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lexicon.LexiconData;
import vazkii.botania.common.lexicon.page.PageRecipe;
import vazkii.botania.common.lexicon.page.PageText;

public class PageArcaneWorkbenchRecipe
extends PageRecipe {
    private static final ResourceLocation craftingOverlay = new ResourceLocation("renaissance_core", "textures/gui/arcanecrafting_overlay.png");
    int relativeMouseX;
    int relativeMouseY;
    ItemStack tooltipStack;
    ItemStack tooltipContainerStack;
    boolean tooltipEntry;
    static boolean mouseDownLastTick = false;
    IArcaneRecipe recipe;
    int ticksElapsed = 0;
    boolean oreDictRecipe;
    boolean shapelessRecipe;

    public PageArcaneWorkbenchRecipe(String unlocalizedName, IArcaneRecipe recipe) {
        super(unlocalizedName);
        this.recipe = recipe;
        this.tooltipStack = ItemStack.field_190927_a;
        this.tooltipContainerStack = ItemStack.field_190927_a;
    }

    public void onPageAdded(LexiconEntry entry, int index) {
        LexiconRecipeMappings.map((ItemStack)this.recipe.func_77571_b(), (LexiconEntry)entry, (int)index);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        ++this.ticksElapsed;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderScreen(IGuiLexiconEntry gui, int mx, int my) {
        this.relativeMouseX = mx;
        this.relativeMouseY = my;
        this.renderRecipe(gui, mx, my);
        int width = gui.getWidth() - 30;
        int height = gui.getHeight();
        int x = gui.getLeft() + 16;
        int y = gui.getTop() + height - 30;
        PageText.renderText((int)x, (int)y, (int)width, (int)height, (String)this.getUnlocalizedName());
        if (!this.tooltipStack.func_190926_b()) {
            List tooltipData = this.tooltipStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            ArrayList<String> parsedTooltip = new ArrayList<String>();
            boolean first = true;
            Iterator iterator = tooltipData.iterator();
            while (iterator.hasNext()) {
                String s;
                String s_ = s = (String)iterator.next();
                if (!first) {
                    s_ = TextFormatting.GRAY + s;
                }
                parsedTooltip.add(s_);
                first = false;
            }
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            int tooltipHeight = tooltipData.size() * 10 + 2;
            int tooltipWidth = parsedTooltip.stream().map(arg_0 -> ((FontRenderer)font).func_78256_a(arg_0)).max((a, b) -> a - b).orElse(0);
            int rmx = mx + 12;
            int rmy = my - 12;
            RenderHelper.renderTooltip((int)mx, (int)my, parsedTooltip);
            GlStateManager.func_179097_i();
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(this.tooltipStack, parsedTooltip, rmx, rmy, font, tooltipWidth, tooltipHeight));
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(this.tooltipStack, parsedTooltip, rmx, rmy, font, tooltipWidth, tooltipHeight));
            GlStateManager.func_179126_j();
            int tooltipY = 8 + tooltipData.size() * 11;
            if (this.tooltipEntry) {
                RenderHelper.renderTooltipOrange((int)mx, (int)(my + tooltipY), Collections.singletonList(TextFormatting.GRAY + I18n.func_135052_a((String)"botaniamisc.clickToRecipe", (Object[])new Object[0])));
                tooltipY += 18;
            }
            if (!this.tooltipContainerStack.func_190926_b()) {
                RenderHelper.renderTooltipGreen((int)mx, (int)(my + tooltipY), Arrays.asList(TextFormatting.AQUA + I18n.func_135052_a((String)"botaniamisc.craftingContainer", (Object[])new Object[0]), this.tooltipContainerStack.func_82833_r()));
            }
        }
        this.tooltipStack = this.tooltipContainerStack = ItemStack.field_190927_a;
        this.tooltipEntry = false;
        GlStateManager.func_179084_k();
        mouseDownLastTick = Mouse.isButtonDown((int)0);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderRecipe(IGuiLexiconEntry gui, int mx, int my) {
        this.shapelessRecipe = false;
        this.oreDictRecipe = false;
        this.renderArcaneCraftingRecipe(gui, this.recipe);
        TextureManager render = Minecraft.func_71410_x().field_71446_o;
        render.func_110577_a(craftingOverlay);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((GuiScreen)gui).func_73729_b(gui.getLeft(), gui.getTop(), 0, 0, gui.getWidth(), gui.getHeight());
        int iconX = gui.getLeft() + 115;
        int iconY = gui.getTop() + 12;
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (this.shapelessRecipe) {
            ((GuiScreen)gui).func_73729_b(iconX, iconY, 240, 0, 16, 16);
            if (mx >= iconX && my >= iconY && mx < iconX + 16 && my < iconY + 16) {
                RenderHelper.renderTooltip((int)mx, (int)my, Collections.singletonList(I18n.func_135052_a((String)"botaniamisc.shapeless", (Object[])new Object[0])));
            }
            iconY += 20;
        }
        render.func_110577_a(craftingOverlay);
        GlStateManager.func_179147_l();
        if (this.oreDictRecipe) {
            ((GuiScreen)gui).func_73729_b(iconX, iconY, 240, 16, 16, 16);
            if (mx >= iconX && my >= iconY && mx < iconX + 16 && my < iconY + 16) {
                RenderHelper.renderTooltip((int)mx, (int)my, Collections.singletonList(I18n.func_135052_a((String)"botaniamisc.oredict", (Object[])new Object[0])));
            }
        }
        GlStateManager.func_179084_k();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderArcaneCraftingRecipe(IGuiLexiconEntry gui, IArcaneRecipe recipe) {
        block11: {
            if (recipe == null) {
                return;
            }
            int twidth = gui.getWidth() - 30;
            int tx = gui.getLeft() + 15;
            int ty = gui.getTop() + 10;
            PageText.renderText((int)tx, (int)ty, (int)twidth, (int)gui.getHeight(), (String)("Vis: " + recipe.getVis()));
            if (recipe instanceof ShapedArcaneRecipe) {
                int width = ((ShapedArcaneRecipe)recipe).getWidth();
                int height = ((ShapedArcaneRecipe)recipe).getHeight();
                this.oreDictRecipe = true;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        Ingredient input = (Ingredient)recipe.func_192400_c().get(y * width + x);
                        ItemStack[] stacks = input.func_193365_a();
                        if (stacks.length <= 0) continue;
                        this.renderItemAtGridPos(gui, 1 + x, 1 + y, stacks[this.ticksElapsed / 40 % stacks.length], true);
                    }
                }
            } else if (recipe instanceof ShapelessArcaneRecipe) {
                this.shapelessRecipe = true;
                for (int y = 0; y < 3; ++y) {
                    for (int x = 0; x < 3; ++x) {
                        int index = y * 3 + x;
                        if (index < recipe.func_192400_c().size()) {
                            Ingredient input = (Ingredient)recipe.func_192400_c().get(index);
                            if (input == Ingredient.field_193370_a) continue;
                            ItemStack[] stacks = input.func_193365_a();
                            this.renderItemAtGridPos(gui, 1 + x, 1 + y, stacks[this.ticksElapsed / 40 % stacks.length], true);
                            continue;
                        }
                        break block11;
                    }
                }
            }
        }
        this.renderItemAtGridPos(gui, 2, 0, recipe.func_77571_b(), false);
        int crystalAmount = 0;
        if (recipe.getCrystals() != null) {
            for (Aspect aspect : recipe.getCrystals().getAspectsSortedByAmount()) {
                ItemStack crystal = new ItemStack(ItemsTC.crystalEssence);
                ((ItemCrystalEssence)ItemsTC.crystalEssence).setAspects(crystal, new AspectList().add(aspect, 1));
                crystal.func_190920_e(recipe.getCrystals().getAmount(aspect));
                this.renderItemAtArcaneGridPos(gui, 1, crystalAmount * 21, crystal, false);
                ++crystalAmount;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItemAtArcaneGridPos(IGuiLexiconEntry gui, int x, int position, ItemStack stack, boolean accountForContainer) {
        if (!stack.func_190926_b()) {
            if ((stack = stack.func_77946_l()).func_77952_i() == Short.MAX_VALUE) {
                stack.func_77964_b(0);
            }
            int xPos = gui.getLeft() + x * 12 + position;
            int yPos = gui.getTop() + 116 + 23;
            ItemStack stack1 = stack.func_77946_l();
            if (stack1.func_77952_i() == -1) {
                stack1.func_77964_b(0);
            }
            this.renderItem(gui, xPos, yPos, stack1, accountForContainer);
        }
    }

    public static void init() {
        LexiconData.virus.pages.set(1, new PageArcaneWorkbenchRecipe("renaissance_core.research", (IArcaneRecipe)new ShapelessArcaneRecipe(new ResourceLocation(""), "HORSEVIRUS", 50, new AspectList().add(Aspect.WATER, 2).add(Aspect.ENTROPY, 2), new ItemStack(ModItems.virus, 1, 0), new Object[]{new ItemStack(Items.field_151144_bL, 1, 2), ModItems.vineBall, new ItemStack(BlocksTC.crystalTaint), "manaPearl", Items.field_151064_bs, Items.field_151071_bq})));
        LexiconData.virus.pages.set(2, new PageArcaneWorkbenchRecipe("renaissance_core.research", (IArcaneRecipe)new ShapelessArcaneRecipe(new ResourceLocation(""), "HORSEVIRUS", 50, new AspectList().add(Aspect.WATER, 2).add(Aspect.ENTROPY, 2), new ItemStack(ModItems.virus, 1, 1), new Object[]{new ItemStack(Items.field_151144_bL, 1, 0), ModItems.vineBall, new ItemStack(BlocksTC.crystalTaint), "manaPearl", Items.field_151064_bs, Items.field_151071_bq})));
        LexiconData.alchemy.pages.set(1, new PageArcaneWorkbenchRecipe("renaissance_core.research", (IArcaneRecipe)new ShapedArcaneRecipe(new ResourceLocation(""), "ALCHEMYCATALYST", 200, new AspectList().add(Aspect.ORDER, 2).add(Aspect.WATER, 1).add(Aspect.EARTH, 1), new ItemStack(ModBlocks.alchemyCatalyst), new Object[]{"LPL", "BAB", "LSL", Character.valueOf('L'), "livingrock", Character.valueOf('P'), "manaPearl", Character.valueOf('S'), "ingotManasteel", Character.valueOf('B'), Items.field_151067_bt, Character.valueOf('A'), new ItemStack(BlocksTC.metalAlchemical)})));
        LexiconData.flasks.pages.set(2, new PageArcaneWorkbenchRecipe("renaissance_core.research", (IArcaneRecipe)new ShapedArcaneRecipe(new ResourceLocation(""), "LARGERVIAL", 75, new AspectList().add(Aspect.WATER, 2), new ItemStack(ModItems.vial, 1, 1), new Object[]{"GBG", "G G", "GGG", Character.valueOf('B'), new ItemStack((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("thaumicaugmentation", "warded_button_greatwood"))), Character.valueOf('G'), new ItemStack(ModBlocks.elfGlass)})));
        LexiconData.decorativeBlocks.pages.set(9, new PageArcaneWorkbenchRecipe("renaissance_core.research", (IArcaneRecipe)new ShapedArcaneRecipe(new ResourceLocation(""), "ALFPORTAL", 100, new AspectList().add(Aspect.WATER, 5).add(Aspect.EARTH, 5), new ItemStack(ModBlocks.livingwood, 6, 5), new Object[]{"LPL", "PAP", "LPL", Character.valueOf('L'), "ingotTerrasteel", Character.valueOf('P'), "livingwood", Character.valueOf('A'), "glowstone"})));
        LexiconData.pylon.pages.set(1, new PageArcaneWorkbenchRecipe("renaissance_core.research", (IArcaneRecipe)new ShapedArcaneRecipe(new ResourceLocation(""), "MANACRYSTAL", 100, new AspectList().add(Aspect.WATER, 2).add(Aspect.ORDER, 2).add(Aspect.AIR, 2), new ItemStack(ModBlocks.pylon, 1, 0), new Object[]{"LHL", "PAP", "LHL", Character.valueOf('L'), new ItemStack(BlocksTC.crystalWater), Character.valueOf('H'), new ItemStack(ModBlocks.storage, 1, 0), Character.valueOf('P'), "ingotGold", Character.valueOf('A'), new ItemStack(ModBlocks.storage, 1, 3)})));
        LexiconData.alfhomancyIntro.pages.set(3, new PageArcaneWorkbenchRecipe("renaissance_core.research", (IArcaneRecipe)new ShapedArcaneRecipe(new ResourceLocation(""), "ALFCRYSTAL", 100, new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 10).add(Aspect.AIR, 5), new ItemStack(ModBlocks.pylon, 1, 1), new Object[]{"LPL", "PAP", "LPL", Character.valueOf('L'), new ItemStack(BlocksTC.crystalEarth), Character.valueOf('P'), "ingotTerrasteel", Character.valueOf('A'), new ItemStack(ModBlocks.pylon, 1, 0)})));
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItem(IGuiLexiconEntry gui, double xPos, double yPos, ItemStack stack, boolean accountForContainer) {
        RenderItem render = Minecraft.func_71410_x().func_175599_af();
        boolean mouseDown = Mouse.isButtonDown((int)0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        GlStateManager.func_179126_j();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)xPos, (double)yPos, (double)0.0);
        render.func_180450_b(stack, 0, 0);
        render.func_175030_a(Minecraft.func_71410_x().field_71466_p, stack, 0, 0);
        GlStateManager.func_179121_F();
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
        int xpi = (int)xPos;
        int ypi = (int)yPos;
        if (this.relativeMouseX >= xpi && this.relativeMouseY >= ypi && this.relativeMouseX <= xpi + 16 && this.relativeMouseY <= ypi + 16) {
            ItemStack containerStack;
            this.tooltipStack = stack;
            LexiconRecipeMappings.EntryData data = LexiconRecipeMappings.getDataForStack((ItemStack)this.tooltipStack);
            ItemStack book = PlayerHelper.getFirstHeldItemClass((EntityPlayer)Minecraft.func_71410_x().field_71439_g, ILexicon.class);
            if (data != null && (data.entry != gui.getEntry() || data.page != gui.getPageOn()) && book != null && ((ILexicon)book.func_77973_b()).isKnowledgeUnlocked(book, data.entry.getKnowledgeType())) {
                this.tooltipEntry = true;
                if (!mouseDownLastTick && mouseDown && GuiScreen.func_146272_n()) {
                    GuiLexiconEntry newGui = new GuiLexiconEntry(data.entry, (GuiScreen)gui);
                    newGui.page = data.page;
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)newGui);
                }
            } else {
                this.tooltipEntry = false;
            }
            if (accountForContainer && !(containerStack = stack.func_77973_b().getContainerItem(stack)).func_190926_b()) {
                this.tooltipContainerStack = containerStack;
            }
        }
        GlStateManager.func_179140_f();
    }
}

