/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.entity;

import com.keletu.renaissance_core.RenaissanceCore;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.casters.FocusEngine;
import thaumcraft.api.casters.FocusPackage;
import thaumcraft.api.casters.Trajectory;
import thaumcraft.common.lib.events.ServerEvents;
import thaumcraft.common.lib.utils.Utils;

public class EntityCompressedBlast
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    private int fireworkAge;
    public int lifetime;
    FocusPackage focusPackage;

    public EntityCompressedBlast(World p_i1762_1_) {
        super(p_i1762_1_);
        this.func_70105_a(0.25f, 0.25f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        return p_70112_1_ < 4096.0;
    }

    public EntityCompressedBlast(World p_i1763_1_, FocusPackage pack, Trajectory trajectory) {
        super(p_i1763_1_);
        this.fireworkAge = 0;
        this.func_70105_a(0.25f, 0.25f);
        this.focusPackage = pack;
        this.func_70107_b(trajectory.source.field_72450_a + trajectory.direction.field_72450_a * (double)pack.getCaster().field_70130_N * 2.1, trajectory.source.field_72448_b + trajectory.direction.field_72448_b * (double)pack.getCaster().field_70130_N * 2.1, trajectory.source.field_72449_c + trajectory.direction.field_72449_c * (double)pack.getCaster().field_70130_N * 2.1);
        this.func_70186_c(trajectory.direction.field_72450_a, trajectory.direction.field_72448_b, trajectory.direction.field_72449_c, 2.1f, 0.0f);
        int i = 1;
        this.lifetime = 5 * i + this.field_70146_Z.nextInt(20);
        this.field_184539_c = pack.getCaster();
        this.field_70192_c = pack.getCaster();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double p_70016_1_, double p_70016_3_, double p_70016_5_) {
        this.field_70159_w = p_70016_1_;
        this.field_70181_x = p_70016_3_;
        this.field_70179_y = p_70016_5_;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(p_70016_1_ * p_70016_1_ + p_70016_5_ * p_70016_5_));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(p_70016_1_, p_70016_5_) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(p_70016_3_, f) * 180.0 / Math.PI);
        }
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        ++this.fireworkAge;
        if (this.field_70170_p.field_72995_K && this.fireworkAge % 2 < 2) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextGaussian() * 0.05, -this.field_70181_x * 0.5, this.field_70146_Z.nextGaussian() * 0.05, new int[0]);
        }
        if (this.field_70170_p.field_72995_K && this.fireworkAge % 5 == 0) {
            RenaissanceCore.proxy.smeltFX(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p, 1);
        }
        if (this.fireworkAge % 5 == 0) {
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), new SoundEvent(new ResourceLocation("renaissance_core:thump")), SoundCategory.PLAYERS, 0.9f, 2.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.8f);
        }
        if (!this.field_70170_p.field_72995_K && this.fireworkAge > this.lifetime) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)17);
            this.func_70106_y();
        }
    }

    protected void func_70184_a(final RayTraceResult mop) {
        if (mop != null && !this.field_70170_p.field_72995_K) {
            if (mop.field_72308_g != null) {
                mop.field_72307_f = this.func_174791_d();
            }
            final Vec3d pv = new Vec3d(this.field_70169_q, this.field_70167_r, this.field_70166_s);
            final Vec3d vf = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            ServerEvents.addRunnableServer((World)this.func_130014_f_(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    FocusEngine.runFocusPackage((FocusPackage)EntityCompressedBlast.this.focusPackage, (Trajectory[])new Trajectory[]{new Trajectory(pv, vf.func_72432_b())}, (RayTraceResult[])new RayTraceResult[]{mop});
                }
            }, (int)0);
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("Life", this.fireworkAge);
        nbt.func_74768_a("LifeTime", this.lifetime);
        nbt.func_74782_a("pack", (NBTBase)this.focusPackage.serialize());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        this.fireworkAge = nbt.func_74762_e("Life");
        this.lifetime = nbt.func_74762_e("LifeTime");
        try {
            this.focusPackage = new FocusPackage();
            this.focusPackage.deserialize(nbt.func_74775_l("pack"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.0f;
    }

    public float func_70013_c() {
        return super.func_70013_c();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return super.func_70070_b();
    }

    public boolean func_70075_an() {
        return false;
    }

    public void writeSpawnData(ByteBuf data) {
        Utils.writeNBTTagCompoundToBuffer((ByteBuf)data, (NBTTagCompound)this.focusPackage.serialize());
    }

    public void readSpawnData(ByteBuf data) {
        try {
            this.focusPackage = new FocusPackage();
            this.focusPackage.deserialize(Utils.readNBTTagCompoundFromBuffer((ByteBuf)data));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

