/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.foci;

import com.keletu.renaissance_core.util.ExperienceHelper;
import fr.wind_blade.isorropia.common.IsorropiaAPI;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.IPlayerWarp;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.NodeSetting;
import thaumcraft.api.casters.Trajectory;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategory;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.utils.RandomItemChooser;

public class FocusReflection
extends FocusEffect {
    private static final int XP = 10;

    public boolean execute(RayTraceResult target, Trajectory trajectory, float finalPower, int i) {
        EntityLivingBase base = this.getPackage().getCaster();
        World world = this.getPackage().world;
        if (target.field_72313_a == RayTraceResult.Type.ENTITY && target.field_72308_g instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)target.field_72308_g;
            IPlayerKnowledge knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)player);
            if (i % 20 == 0) {
                this.getPackage().world.func_184133_a(null, player.func_180425_c(), SoundsTC.whispers, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            }
            if (this.getSettingValue("function") == 1) {
                boolean success;
                if (i % 5 == 0 && (success = knowledge.addKnowledge(IPlayerKnowledge.EnumKnowledgeType.THEORY, this.selectCategory(player, knowledge), -5))) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + I18n.func_74838_a((String)"TC.oblivion_response")));
                    ThaumcraftApi.internalMethods.addWarpToPlayer(player, 10 + this.getSettingValue("power") * 2, IPlayerWarp.EnumWarpType.TEMPORARY);
                }
            } else if (player.field_71067_cb >= Math.max(1, 10 - this.getSettingValue("power"))) {
                ExperienceHelper.drainPlayerXP(player, Math.max(1, 10 - this.getSettingValue("power")));
                ThaumcraftApi.internalMethods.addWarpToPlayer(player, 1 + this.getSettingValue("power"), IPlayerWarp.EnumWarpType.TEMPORARY);
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderParticleFX(World world, double x, double y, double z, double vx, double vy, double vz) {
        FXGeneric pp = new FXGeneric(world, x, y, z, vx, vy, vz);
        pp.func_187114_a(9);
        pp.func_70538_b(0.25f + world.field_73012_v.nextFloat() * 0.25f, 0.25f + world.field_73012_v.nextFloat() * 0.25f, 0.25f + world.field_73012_v.nextFloat() * 0.25f);
        pp.setAlphaF(new float[]{0.0f, 0.6f, 0.6f, 0.0f});
        pp.setGridSize(64);
        pp.setParticles(448, 9, 1);
        pp.setScale(new float[]{0.5f, 0.25f});
        pp.setGravity((float)(world.field_73012_v.nextGaussian() * (double)0.009f));
        pp.setRandomMovementScale(0.0025f, 0.0025f, 0.0025f);
        ParticleEngine.addEffect((World)world, (Particle)pp);
    }

    public NodeSetting[] createSettings() {
        int[] function = new int[]{0, 1};
        String[] functionkDesc = new String[]{"rcfocus.reflection.common", "rcfocus.reflection.oblivion"};
        return new NodeSetting[]{new NodeSetting("power", "rcfocus.reflection.power", (NodeSetting.INodeSettingType)new NodeSetting.NodeSettingIntRange(1, 3)), new NodeSetting("function", "rcfocus.reflection.function", (NodeSetting.INodeSettingType)new NodeSetting.NodeSettingIntList(function, functionkDesc))};
    }

    public int getComplexity() {
        return this.getSettingValue("power") * 15 + (this.getSettingValue("oblivion") == 0 ? 0 : 5);
    }

    public Aspect getAspect() {
        return IsorropiaAPI.SLOTH;
    }

    public String getKey() {
        return "renaissance_core.REFLECTION";
    }

    public String getResearch() {
        return "!FocusReflection";
    }

    @Nullable
    protected ResearchCategory selectCategory(EntityPlayer player, IPlayerKnowledge knowledge) {
        ArrayList<CategoryEntry> selectionList = new ArrayList<CategoryEntry>();
        for (ResearchCategory category : ResearchCategories.researchCategories.values()) {
            int count = knowledge.getKnowledge(IPlayerKnowledge.EnumKnowledgeType.THEORY, category);
            if (count <= 0) continue;
            selectionList.add(new CategoryEntry(category, count));
        }
        if (selectionList.size() <= 0) {
            return null;
        }
        RandomItemChooser ric = new RandomItemChooser();
        CategoryEntry selected = (CategoryEntry)ric.chooseOnWeight(selectionList);
        if (selected == null) {
            return null;
        }
        return selected.category;
    }

    protected static class CategoryEntry
    implements RandomItemChooser.Item {
        public ResearchCategory category;
        public int weight;

        protected CategoryEntry(ResearchCategory category, int weight) {
            this.category = category;
            this.weight = weight;
        }

        public double getWeight() {
            return this.weight;
        }
    }
}

