/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.entity;

import com.keletu.renaissance_core.RenaissanceCore;
import com.keletu.renaissance_core.blocks.TileHexOfPredictability;
import com.keletu.renaissance_core.entity.EntityCrimsonPontifex;
import com.keletu.renaissance_core.packet.PacketFXLightning;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.capabilities.IPlayerWarp;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.casters.FocusEngine;
import thaumcraft.api.casters.FocusMediumRoot;
import thaumcraft.api.casters.FocusPackage;
import thaumcraft.api.casters.IFocusElement;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.potions.PotionFluxTaint;
import thaumcraft.common.blocks.world.taint.TaintHelper;
import thaumcraft.common.entities.EntityFluxRift;
import thaumcraft.common.entities.monster.EntityWisp;
import thaumcraft.common.entities.monster.tainted.EntityTaintSeedPrime;
import thaumcraft.common.items.casters.foci.FocusEffectFlux;
import thaumcraft.common.items.casters.foci.FocusMediumCloud;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXBlockBamf;
import thaumcraft.common.lib.potions.PotionInfectiousVisExhaust;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.lib.utils.RandomItemChooser;

public class EntityHexRift
extends EntityFluxRift
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> SEED = EntityDataManager.func_187226_a(EntityHexRift.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SIZE = EntityDataManager.func_187226_a(EntityHexRift.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> STABILITY = EntityDataManager.func_187226_a(EntityHexRift.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> COLLAPSE = EntityDataManager.func_187226_a(EntityHexRift.class, (DataSerializer)DataSerializers.field_187198_h);
    int maxSize = 0;
    int lastSize = -1;
    static ArrayList<RandomItemChooser.Item> events = new ArrayList();
    public int hexX = 0;
    public int hexY = 0;
    public int hexZ = 0;
    public boolean chained = false;

    public EntityHexRift(World par1World) {
        super(par1World);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(SEED, (Object)0);
        this.func_184212_Q().func_187214_a(SIZE, (Object)5);
        this.func_184212_Q().func_187214_a(STABILITY, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(COLLAPSE, (Object)false);
    }

    public int getRiftSeed() {
        return (Integer)this.func_184212_Q().func_187225_a(SEED);
    }

    public void setRiftSeed(int s) {
        this.func_184212_Q().func_187227_b(SEED, (Object)s);
    }

    public boolean getCollapse() {
        return (Boolean)this.func_184212_Q().func_187225_a(COLLAPSE);
    }

    public void setCollapse(boolean b) {
        if (b) {
            this.maxSize = this.getRiftSize();
        }
        this.func_184212_Q().func_187227_b(COLLAPSE, (Object)b);
    }

    public float getRiftStability() {
        return ((Float)this.func_184212_Q().func_187225_a(STABILITY)).floatValue();
    }

    public void setRiftStability(float s) {
        if (s > 100.0f) {
            s = 100.0f;
        }
        if (s < -100.0f) {
            s = -100.0f;
        }
        this.func_184212_Q().func_187227_b(STABILITY, (Object)Float.valueOf(s));
    }

    public int getRiftSize() {
        return (Integer)this.func_184212_Q().func_187225_a(SIZE);
    }

    public void setRiftSize(int s) {
        this.func_184212_Q().func_187227_b(SIZE, (Object)s);
        this.setSize();
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Chained", this.chained);
        nbttagcompound.func_74783_a("Hex", new int[]{this.hexX, this.hexY, this.hexZ});
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.chained = nbttagcompound.func_74767_n("Chained");
        int[] hex = nbttagcompound.func_74759_k("Hex");
        this.hexX = hex[0];
        this.hexY = hex[1];
        this.hexZ = hex[2];
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.chained);
    }

    public void readSpawnData(ByteBuf additionalData) {
        try {
            this.chained = additionalData.readBoolean();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_70071_h_() {
        if (!this.points.isEmpty() && this.chained) {
            int pi = this.field_70146_Z.nextInt(this.points.size() - 1);
            Vec3d copy = (Vec3d)this.points.get(pi);
            Vec3d v1 = new Vec3d(copy.field_72450_a, copy.field_72448_b, copy.field_72449_c).func_72441_c(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v);
            TileEntity tile = this.field_70170_p.func_175625_s(new BlockPos(this.hexX, this.hexY, this.hexZ));
            if (!this.field_70170_p.field_72995_K && !(tile instanceof TileHexOfPredictability)) {
                this.func_70106_y();
            }
            if (tile instanceof TileHexOfPredictability) {
                List items = EntityUtils.getEntitiesInRange((World)this.field_70170_p, (double)v1.field_72450_a, (double)v1.field_72448_b, (double)v1.field_72449_c, (Entity)this, EntityItem.class, (double)1.4);
                if (!this.field_70170_p.field_72995_K && !items.isEmpty()) {
                    for (EntityItem item : items) {
                        if (!item.func_92059_d().func_77973_b().equals(ItemsTC.curio) || item.func_92059_d().func_77952_i() != 6) continue;
                        if (item.func_145800_j() != null && ThaumcraftCapabilities.knowsResearch((EntityPlayer)this.field_70170_p.func_72924_a(item.func_145800_j()), (String[])new String[]{"CRIMSONPONTIFEX@0"})) {
                            this.field_70170_p.func_72876_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, 3.0f, false);
                            EntityCrimsonPontifex pontifex = new EntityCrimsonPontifex(this.field_70170_p);
                            pontifex.func_70080_a(this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, this.field_70170_p.field_73012_v.nextInt(360) - 180, 0.0f);
                            pontifex.field_70759_as = pontifex.field_70177_z;
                            pontifex.field_70761_aq = pontifex.field_70177_z;
                            pontifex.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                            this.field_70170_p.func_72838_d((Entity)pontifex);
                        }
                        item.func_70106_y();
                        this.func_70106_y();
                    }
                    if (((TileHexOfPredictability)tile).heat > 0 && ((TileHexOfPredictability)tile).essentia.size() > 0) {
                        this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundsTC.jacobs, SoundCategory.NEUTRAL, 0.5f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
                        List shrinked = items.stream().limit(6L).collect(Collectors.toList());
                        for (Entity i : shrinked) {
                            Aspect[] aspects = ((TileHexOfPredictability)tile).essentia.getAspects();
                            int rgb = aspects[this.field_70170_p.field_73012_v.nextInt(aspects.length)].getColor();
                            RenaissanceCore.packetInstance.sendToAllAround((IMessage)new PacketFXLightning((float)v1.field_72450_a, (float)v1.field_72448_b, (float)v1.field_72449_c, (float)i.field_70165_t, (float)i.field_70163_u, (float)i.field_70161_v, rgb, (float)((TileHexOfPredictability)tile).heat / 2400.0f * 2.0f), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 32.0));
                        }
                    }
                }
            }
        } else {
            super.func_70071_h_();
        }
    }

    public static void constructRift(World world, int x, int y, int z, int size) {
        Vec3d p2 = new Vec3d((double)x, (double)y, (double)z);
        EntityHexRift rift = new EntityHexRift(world);
        rift.setRiftSeed(world.field_73012_v.nextInt());
        rift.func_70012_b(p2.field_72450_a, p2.field_72448_b, p2.field_72449_c, world.field_73012_v.nextInt(360), 0.0f);
        size = MathHelper.func_76125_a((int)size, (int)5, (int)150);
        rift.chained = true;
        rift.hexX = x;
        rift.hexY = y - 2;
        rift.hexZ = z;
        if (world.func_72838_d((Entity)rift)) {
            rift.field_70165_t = p2.field_72450_a + 0.5;
            rift.field_70163_u = p2.field_72448_b;
            rift.field_70161_v = p2.field_72449_c + 0.5;
            rift.setRiftSize(5);
            rift.setRiftSize(size);
            rift.setCollapse(false);
        }
    }

    private void executeRiftEvent() {
        RandomItemChooser ric = new RandomItemChooser();
        FluxEventEntry ei = (FluxEventEntry)ric.chooseOnWeight(events);
        if (ei != null && (ei.nearTaintAllowed || !TaintHelper.isNearTaintSeed((World)this.field_70170_p, (BlockPos)this.func_180425_c()))) {
            boolean didit = false;
            switch (ei.event) {
                case 0: {
                    EntityWisp wisp = new EntityWisp(this.field_70170_p);
                    wisp.func_70012_b(this.field_70165_t + this.field_70146_Z.nextGaussian() * 5.0, this.field_70163_u + this.field_70146_Z.nextGaussian() * 5.0, this.field_70161_v + this.field_70146_Z.nextGaussian() * 5.0, 0.0f, 0.0f);
                    if (this.field_70170_p.field_73012_v.nextInt(5) == 0) {
                        wisp.setType(Aspect.FLUX.getTag());
                    }
                    if (!wisp.func_70601_bi() || !this.field_70170_p.func_72838_d((Entity)wisp)) break;
                    didit = true;
                    break;
                }
                case 1: {
                    EntityTaintSeedPrime seed = new EntityTaintSeedPrime(this.field_70170_p);
                    seed.func_70012_b((double)((int)(this.field_70165_t + this.field_70146_Z.nextGaussian() * 5.0)) + 0.5, (double)((int)(this.field_70163_u + this.field_70146_Z.nextGaussian() * 5.0)), (double)((int)(this.field_70161_v + this.field_70146_Z.nextGaussian() * 5.0)) + 0.5, (float)this.field_70170_p.field_73012_v.nextInt(360), 0.0f);
                    if (!seed.func_70601_bi() || !this.field_70170_p.func_72838_d((Entity)seed)) break;
                    didit = true;
                    seed.boost = this.getRiftSize();
                    AuraHelper.polluteAura((World)this.func_130014_f_(), (BlockPos)this.func_180425_c(), (float)(this.getRiftSize() / 2), (boolean)true);
                    this.func_70106_y();
                    break;
                }
                case 2: {
                    List targets2 = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0));
                    if (targets2 == null || targets2.size() <= 0) break;
                    for (EntityLivingBase target : targets2) {
                        didit = true;
                        if (target instanceof EntityPlayer) {
                            ((EntityPlayer)target).func_146105_b((ITextComponent)new TextComponentString("\u00a75\u00a7o" + I18n.func_74838_a((String)"tc.fluxevent.2")), true);
                        }
                        PotionEffect pe = new PotionEffect(PotionInfectiousVisExhaust.instance, 3000, 2);
                        pe.getCurativeItems().clear();
                        try {
                            target.func_70690_d(pe);
                        }
                        catch (Exception exception) {}
                    }
                    break;
                }
                case 3: {
                    EntityPlayer target = this.field_70170_p.func_72890_a((Entity)this, 16.0);
                    if (target == null) break;
                    FocusPackage p = new FocusPackage((EntityLivingBase)target);
                    FocusMediumRoot root = new FocusMediumRoot();
                    root.setupFromCasterToTarget((EntityLivingBase)target, (Entity)target, 0.5);
                    p.addNode((IFocusElement)root);
                    FocusMediumCloud fp = new FocusMediumCloud();
                    fp.initialize();
                    fp.getSetting("radius").setValue(MathHelper.func_76136_a((Random)this.field_70146_Z, (int)1, (int)3));
                    fp.getSetting("duration").setValue(MathHelper.func_76136_a((Random)this.field_70146_Z, (int)Math.min(this.getRiftSize() / 2, 30), (int)Math.min(this.getRiftSize(), 120)));
                    p.addNode((IFocusElement)fp);
                    p.addNode((IFocusElement)new FocusEffectFlux());
                    FocusEngine.castFocusPackage((EntityLivingBase)target, (FocusPackage)p, (boolean)true);
                    break;
                }
                case 4: {
                    this.setCollapse(true);
                }
            }
            if (didit) {
                this.setRiftStability(this.getRiftStability() + (float)ei.cost);
            }
        }
    }

    private void calcSteps(ArrayList<Vec3d> pp, ArrayList<Float> ww, Random rr) {
        pp.clear();
        ww.clear();
        Vec3d right = new Vec3d(rr.nextGaussian(), rr.nextGaussian(), rr.nextGaussian()).func_72432_b();
        Vec3d left = right.func_186678_a(-1.0);
        Vec3d lr = new Vec3d(0.0, 0.0, 0.0);
        Vec3d ll = new Vec3d(0.0, 0.0, 0.0);
        int steps = MathHelper.func_76123_f((float)((float)this.getRiftSize() / 3.0f));
        float girth = (float)this.getRiftSize() / 300.0f;
        double angle = 0.33;
        float dec = girth / (float)steps;
        for (int a = 0; a < steps; ++a) {
            girth -= dec;
            right = right.func_178789_a((float)(rr.nextGaussian() * angle));
            right = right.func_178785_b((float)(rr.nextGaussian() * angle));
            lr = lr.func_178787_e(right.func_186678_a(0.2));
            pp.add(new Vec3d(lr.field_72450_a, lr.field_72448_b, lr.field_72449_c));
            ww.add(Float.valueOf(girth));
            left = left.func_178789_a((float)(rr.nextGaussian() * angle));
            left = left.func_178785_b((float)(rr.nextGaussian() * angle));
            ll = ll.func_178787_e(left.func_186678_a(0.2));
            pp.add(0, new Vec3d(ll.field_72450_a, ll.field_72448_b, ll.field_72449_c));
            ww.add(0, Float.valueOf(girth));
        }
        lr = lr.func_178787_e(right.func_186678_a(0.1));
        pp.add(new Vec3d(lr.field_72450_a, lr.field_72448_b, lr.field_72449_c));
        ww.add(Float.valueOf(0.0f));
        ll = ll.func_178787_e(left.func_186678_a(0.1));
        pp.add(0, new Vec3d(ll.field_72450_a, ll.field_72448_b, ll.field_72449_c));
        ww.add(0, Float.valueOf(0.0f));
    }

    private void completeCollapse() {
        block10: {
            int w;
            int qq = (int)Math.sqrt(this.maxSize);
            if (this.field_70146_Z.nextInt(100) < qq) {
                this.func_70099_a(new ItemStack(ItemsTC.primordialPearl, 1, 4 + this.field_70146_Z.nextInt(4)), 0.0f);
            }
            for (int a = 0; a < qq; ++a) {
                this.func_70099_a(new ItemStack(ItemsTC.voidSeed), 0.0f);
            }
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockBamf(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0, true, true, null), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
            List list = EntityUtils.getEntitiesInRange((World)this.field_70170_p, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (Entity)this, EntityLivingBase.class, (double)32.0);
            switch (this.getStability()) {
                case VERY_UNSTABLE: {
                    for (EntityLivingBase p : list) {
                        w = (int)((1.0 - p.func_70068_e((Entity)this) / 32.0) * 120.0);
                        if (w <= 0) continue;
                        p.func_70690_d(new PotionEffect(PotionFluxTaint.instance, w * 20, 0));
                    }
                }
                case UNSTABLE: {
                    for (EntityLivingBase p : list) {
                        w = (int)((1.0 - p.func_70068_e((Entity)this) / 32.0) * 300.0);
                        if (w <= 0) continue;
                        p.func_70690_d(new PotionEffect(MobEffects.field_76437_t, w * 20, 0));
                    }
                }
                case STABLE: {
                    break;
                }
                default: {
                    break block10;
                }
            }
            for (EntityLivingBase p : list) {
                if (!(p instanceof EntityPlayer) || (w = (int)((1.0 - p.func_70068_e((Entity)this) / 32.0) * 25.0)) <= 0) continue;
                ThaumcraftApi.internalMethods.addWarpToPlayer((EntityPlayer)p, w, IPlayerWarp.EnumWarpType.NORMAL);
                ThaumcraftApi.internalMethods.addWarpToPlayer((EntityPlayer)p, w, IPlayerWarp.EnumWarpType.TEMPORARY);
            }
        }
        this.func_70106_y();
    }

    static {
        events.add(new FluxEventEntry(0, 50, 5, true));
        events.add(new FluxEventEntry(1, 10, 0, false));
        events.add(new FluxEventEntry(2, 20, 10, true));
        events.add(new FluxEventEntry(3, 20, 10, true));
        events.add(new FluxEventEntry(4, 1, 0, true));
    }

    static class FluxEventEntry
    implements RandomItemChooser.Item {
        int weight;
        int event;
        int cost;
        boolean nearTaintAllowed;

        protected FluxEventEntry(int event, int weight, int cost, boolean nearTaintAllowed) {
            this.weight = weight;
            this.event = event;
            this.cost = cost;
            this.nearTaintAllowed = nearTaintAllowed;
        }

        public double getWeight() {
            return this.weight;
        }
    }
}

