/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.renaissance_core.util;

import com.keletu.renaissance_core.compat.crafttweaker.TweakerHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.crafting.IThaumcraftRecipe;

public class ChainedRiftRecipe
implements IThaumcraftRecipe {
    static ArrayList<ChainedRiftRecipe> riftRecipes = new ArrayList();
    private final ItemStack recipeOutput;
    public Object catalyst;
    public AspectList aspects;
    public String key;
    public int hash;

    public static void addRiftRecipe(ResourceLocation registry, ChainedRiftRecipe recipe) {
        ThaumcraftApi.getCraftingRecipes().put(registry, recipe);
    }

    public ChainedRiftRecipe(String researchKey, ItemStack result, Object cat, AspectList tags) {
        this.recipeOutput = result;
        this.aspects = tags;
        this.key = researchKey;
        this.catalyst = cat;
        if (cat instanceof String) {
            this.catalyst = OreDictionary.getOres((String)((String)cat));
        }
        String hc = researchKey + result.toString();
        for (Aspect tag : tags.getAspects()) {
            hc = hc + tag.getTag() + tags.getAmount(tag);
        }
        if (cat instanceof ItemStack) {
            hc = hc + ((ItemStack)cat).toString();
        } else if (cat instanceof ArrayList && ((ArrayList)this.catalyst).size() > 0) {
            for (ItemStack is : (ArrayList)this.catalyst) {
                hc = hc + is.toString();
            }
        }
        this.hash = hc.hashCode();
    }

    public static ChainedRiftRecipe addChainedRiftRecipe(String key, ItemStack result, Object catalyst, AspectList tags) {
        ChainedRiftRecipe recipe = new ChainedRiftRecipe(key, result, catalyst, tags);
        riftRecipes.add(recipe);
        return recipe;
    }

    public static ChainedRiftRecipe findMatchingRiftRecipe(EntityPlayer username, AspectList aspects, ItemStack lastDrop) {
        int highest = 0;
        int index = -1;
        for (int a = 0; a < riftRecipes.size(); ++a) {
            int result;
            ChainedRiftRecipe recipe = riftRecipes.get(a);
            ItemStack temp = lastDrop.func_77946_l();
            temp.func_190920_e(1);
            if (!ThaumcraftCapabilities.knowsResearch((EntityPlayer)username, (String[])new String[]{recipe.key}) || !recipe.matches(aspects, temp) || (result = recipe.aspects.size()) <= highest) continue;
            highest = result;
            index = a;
        }
        if (index < 0) {
            return null;
        }
        new AspectList();
        return riftRecipes.get(index);
    }

    public boolean matches(AspectList itags, ItemStack cat) {
        ArrayList ores;
        if (this.catalyst instanceof ItemStack && !ThaumcraftApiHelper.areItemsEqual((ItemStack)((ItemStack)this.catalyst), (ItemStack)cat)) {
            return false;
        }
        if (this.catalyst instanceof ArrayList && ((ArrayList)this.catalyst).size() > 0 && !ThaumcraftApiHelper.containsMatch((boolean)false, (ItemStack[])new ItemStack[]{cat}, (List)(ores = (ArrayList)this.catalyst))) {
            return false;
        }
        if (itags == null) {
            return false;
        }
        for (Aspect tag : this.aspects.getAspects()) {
            if (itags.getAmount(tag) >= this.aspects.getAmount(tag)) continue;
            return false;
        }
        return true;
    }

    public boolean catalystMatches(ItemStack cat) {
        if (this.catalyst instanceof ItemStack && ThaumcraftApiHelper.areItemsEqual((ItemStack)((ItemStack)this.catalyst), (ItemStack)cat)) {
            return true;
        }
        if (this.catalyst instanceof ArrayList && ((ArrayList)this.catalyst).size() > 0) {
            ArrayList ores = (ArrayList)this.catalyst;
            return ThaumcraftApiHelper.containsMatch((boolean)false, (ItemStack[])new ItemStack[]{cat}, (List)ores);
        }
        return false;
    }

    public AspectList removeMatching(AspectList itags) {
        AspectList temptags = new AspectList();
        temptags.aspects.putAll(itags.aspects);
        for (Aspect tag : this.aspects.getAspects()) {
            temptags.remove(tag, this.aspects.getAmount(tag));
        }
        itags = temptags;
        return itags;
    }

    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    public boolean equals(Object o) {
        if (o instanceof ChainedRiftRecipe) {
            ChainedRiftRecipe recipe = (ChainedRiftRecipe)o;
            return this.key.equals(recipe.key) && this.catalyst.equals(recipe.catalyst) && TweakerHelper.aspectsToString(this.aspects).equals(TweakerHelper.aspectsToString(recipe.aspects)) && ItemStack.func_77989_b((ItemStack)this.recipeOutput, (ItemStack)recipe.getRecipeOutput());
        }
        return false;
    }

    public String getResearch() {
        return this.key;
    }

    public String getGroup() {
        return "";
    }
}

